/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/DeviceIdManager;", "", "()V", "DEVICE_ID_PREFERENCE_KEY", "", "DEVICE_ID_SHARED_FILE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "generateId", "calendar", "Ljava/util/Calendar;", "OSChar", "", "getOSChar", "getOrGenerateId", "getPreferences", "Ljava/util/prefs/Preferences;", "appInfo", "Lcom/intellij/openapi/application/ex/ApplicationInfoEx;", "intellij.platform.ide.impl"})
public final class DeviceIdManager {
    private static final Logger LOG;
    private static final String DEVICE_ID_SHARED_FILE = "PermanentDeviceId";
    private static final String DEVICE_ID_PREFERENCE_KEY = "device_id";
    public static final DeviceIdManager INSTANCE;

    @NotNull
    public final String getOrGenerateId() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        Preferences prefs = this.getPreferences(appInfo);
        String deviceId = prefs.get(DEVICE_ID_PREFERENCE_KEY, null);
        if (StringUtil.isEmptyOrSpaces((String)deviceId)) {
            deviceId = this.generateId(Calendar.getInstance(), this.getOSChar());
            prefs.put(DEVICE_ID_PREFERENCE_KEY, deviceId);
            LOG.info("Generating new Device ID");
        }
        if (appInfo.isVendorJetBrains() && SystemInfo.isWindows) {
            deviceId = PermanentInstallationID.syncWithSharedFile(DEVICE_ID_SHARED_FILE, deviceId, prefs, DEVICE_ID_PREFERENCE_KEY);
        }
        return deviceId;
    }

    private final Preferences getPreferences(ApplicationInfoEx appInfo) {
        String string;
        String companyName = appInfo.getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string2 = companyName;
            Locale locale = Locale.US;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        return Preferences.userRoot().node(name);
    }

    @NotNull
    public final String generateId(@NotNull Calendar calendar, char OSChar) {
        calendar.set(1, RangesKt.coerceIn((int)calendar.get(1), (int)2000, (int)2099));
        return new SimpleDateFormat("ddMMyy").format(calendar.getTime()) + OSChar + UUID.randomUUID().toString();
    }

    private final char getOSChar() {
        return (char)(SystemInfo.isWindows ? 49 : (SystemInfo.isMac ? 50 : (SystemInfo.isLinux ? 51 : 48)));
    }

    private DeviceIdManager() {
    }

    static {
        DeviceIdManager deviceIdManager;
        INSTANCE = deviceIdManager = new DeviceIdManager();
        LOG = Logger.getInstance(DeviceIdManager.class);
    }
}

