/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import org.jetbrains.annotations.NotNull;

public class RecordStateStatisticsEventLogAction
extends AnAction {
    private static final FUStateUsagesLogger myStatesLogger = new FUStateUsagesLogger();
    private static final EventLogExternalSettingsService myEventLogSettingsService = EventLogExternalSettingsService.getInstance();

    public void actionPerformed(final @NotNull AnActionEvent e) {
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Collecting Feature Usages In Event Log", false){

            public void run(@NotNull ProgressIndicator indicator) {
                String serviceUrl = myEventLogSettingsService.getServiceUrl();
                if (serviceUrl == null) {
                    return;
                }
                FUSWhitelist whitelist = myEventLogSettingsService.getApprovedGroups();
                if (whitelist.isEmpty() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
                    return;
                }
                myStatesLogger.logApplicationStates(whitelist, true);
                myStatesLogger.logProjectStates(project, whitelist, true);
                ApplicationManager.getApplication().invokeLater(() -> RecordStateStatisticsEventLogAction.this.showNotification(project, e, "Collecting and recording events was finished"));
            }
        });
    }

    protected void showNotification(@NotNull Project project, @NotNull AnActionEvent event, @NotNull String message) {
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setFadeoutTime(2000L).setDisposable((Disposable)project).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext()), Balloon.Position.below);
    }
}

