/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestParseEventLogWhitelistDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(TestParseEventLogWhitelistDialog.class);
    private static final int IN_DIVIDER_LOCATION = 650;
    private static final int IN_OUT_DIVIDER_LOCATION = 300;
    private JPanel myMainPanel;
    private JPanel myWhitelistPanel;
    private JPanel myResultPanel;
    private JEditorPane myEventLogPanel;
    private JSplitPane myInputDataSplitPane;
    private JSplitPane myInputOutputSplitPane;
    private final Project myProject;
    private final EditorEx myWhitelistEditor;
    private final EditorEx myResultEditor;
    private final List<PsiFile> myTempFiles;

    protected TestParseEventLogWhitelistDialog(@NotNull Project project, @Nullable Editor selectedEditor) {
        super(project);
        this.$$$setupUI$$$();
        this.myTempFiles = ContainerUtil.newArrayList();
        this.myProject = project;
        this.setOKButtonText("&Filter Event Log");
        this.setCancelButtonText("&Close");
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        VirtualFile selectedFile = selectedEditor == null ? null : FileDocumentManager.getInstance().getFile(selectedEditor.getDocument());
        this.setTitle(selectedFile == null ? "Event Log Filter" : "Event Log Filter by: " + selectedFile.getName());
        this.myWhitelistEditor = this.initEditor(selectedEditor, "event-log-whitelist", "{\"groups\":[]}");
        this.myWhitelistEditor.getSettings().setLineMarkerAreaShown(false);
        this.myResultEditor = this.initEditor(null, "event-log-filter-result", "{}");
        this.myResultEditor.getSettings().setLineMarkerAreaShown(false);
        this.init();
        if (selectedEditor != null) {
            this.doOKAction();
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myWhitelistEditor.getContentComponent(), true));
                this.myWhitelistEditor.getCaretModel().moveToOffset(selectedEditor.getCaretModel().getOffset());
                this.myWhitelistEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }, ModalityState.stateForComponent((Component)this.myMainPanel));
        }
    }

    @NotNull
    private EditorEx initEditor(@Nullable Editor selectedEditor, @NotNull String fileName2, @NotNull String templateText) {
        if (selectedEditor != null) {
            return (EditorEx)EditorFactory.getInstance().createEditor(selectedEditor.getDocument(), this.myProject);
        }
        PsiFile file2 = TestParseEventLogWhitelistDialog.createTempFile(this.myProject, fileName2, templateText);
        assert (file2 != null);
        this.myTempFiles.add(file2);
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)templateText);
        }
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject, file2.getVirtualFile(), false);
        editor.setFile(file2.getVirtualFile());
        return editor;
    }

    @Nullable
    private static PsiFile createTempFile(@NotNull Project project, @NotNull String filename, @NotNull String request) {
        String fileName2 = PathUtil.makeFileName((String)filename, (String)"json");
        try {
            ThrowableComputable computable = () -> {
                Document document;
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile(RootType.findById((String)"scratches"), fileName2, ScratchFileService.Option.create_if_missing);
                fileService.getScratchesMapping().setMapping(file2, (Object)Language.findLanguageByID((String)"JSON"));
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                if (document == null) {
                    return null;
                }
                document.insertString(document.getTextLength(), (CharSequence)request);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return psiFile;
            };
            return (PsiFile)WriteCommandAction.writeCommandAction((Project)project).withName("Creating temp JSON file for event log").withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(computable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void init() {
        TestParseEventLogWhitelistDialog.configEditorPanel(this.myProject, this.myWhitelistPanel, this.myWhitelistEditor);
        TestParseEventLogWhitelistDialog.configEditorPanel(this.myProject, this.myResultPanel, this.myResultEditor);
        this.myInputDataSplitPane.setDividerLocation(650);
        this.myInputOutputSplitPane.setDividerLocation(300);
        super.init();
    }

    private static void configEditorPanel(@NotNull Project project, @NotNull JPanel panel2, @NotNull EditorEx editor) {
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)editor.getComponent(), "Center");
        editor.getSettings().setFoldingOutlineShown(false);
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JSON");
        LightVirtualFile lightFile = new LightVirtualFile("Dummy.json", fileType, (CharSequence)"");
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, (VirtualFile)lightFile);
        try {
            editor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return TestParseEventLogWhitelistDialog.class.getCanonicalName();
    }

    protected void doOKAction() {
        this.myWhitelistEditor.getSelectionModel().removeSelection();
        this.myResultEditor.getSelectionModel().removeSelection();
        this.updateResultRequest("{}");
        BuildNumber build2 = BuildNumber.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
        FUSWhitelist whitelist = FUStatisticsWhiteListGroupsService.parseApprovedGroups(this.myWhitelistEditor.getDocument().getText(), build2);
        try {
            String parsed = TestParseEventLogWhitelistDialog.parseLogAndFilter(new LogEventWhitelistFilter(whitelist), this.myEventLogPanel.getText());
            this.updateResultRequest(parsed.trim());
        }
        catch (ParseEventLogWhitelistException | IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)"Failed Applying Whitelist to Event Log");
        }
    }

    private void updateResultRequest(@NotNull String text) {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            DocumentEx document = this.myResultEditor.getDocument();
            document.setText(text);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument((Document)this.myResultEditor.getDocument());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String parseLogAndFilter(@NotNull LogEventFilter filter, @NotNull String text) throws IOException, ParseEventLogWhitelistException {
        File log2 = FileUtil.createTempFile((String)"feature-event-log", (String)".log");
        try {
            FileUtil.writeToFile((File)log2, (String)text);
            LogEventRecordRequest request = LogEventRecordRequest.Companion.create(log2, filter, true);
            if (request == null) {
                throw new ParseEventLogWhitelistException("Failed parsing event log");
            }
            String string = LogEventSerializer.INSTANCE.toString(request);
            return string;
        }
        finally {
            FileUtil.delete((File)log2);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEventLogPanel;
    }

    public void dispose() {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            for (PsiFile file2 : this.myTempFiles) {
                try {
                    file2.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (!this.myWhitelistEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myWhitelistEditor);
        }
        if (!this.myResultEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myResultEditor);
        }
        super.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JSplitPane jSplitPane;
        JEditorPane jEditorPane;
        JSplitPane jSplitPane2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInputOutputSplitPane = jSplitPane2 = new JSplitPane();
        jSplitPane2.setOrientation(0);
        jPanel3.add((Component)jSplitPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane2.setRightComponent((Component)jBScrollPane);
        this.myEventLogPanel = jEditorPane = new JEditorPane();
        jEditorPane.setText("Add event log to filter here, one event per line");
        jBScrollPane.setViewportView(jEditorPane);
        this.myInputDataSplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(230);
        jSplitPane.setDividerSize(2);
        jSplitPane2.setLeftComponent(jSplitPane);
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jSplitPane.setLeftComponent((Component)jBScrollPane2);
        this.myWhitelistPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel2);
        JBScrollPane jBScrollPane3 = new JBScrollPane();
        jSplitPane.setRightComponent((Component)jBScrollPane3);
        this.myResultPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static class ParseEventLogWhitelistException
    extends Exception {
        public ParseEventLogWhitelistException(String s) {
            super(s);
        }
    }
}

