/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.beans;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class ConvertUsagesUtil {
    static final char GROUP_SEPARATOR = ':';
    static final char GROUPS_SEPARATOR = ';';
    static final char GROUP_VALUE_SEPARATOR = ',';

    private ConvertUsagesUtil() {
    }

    public static <T extends UsageDescriptor> String convertUsages(Map<String, Set<T>> map2) {
        assert (map2 != null);
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, Set<T>> entry : map2.entrySet()) {
            String value = ConvertUsagesUtil.convertValueMap(entry.getValue());
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            buffer.append(entry.getKey());
            buffer.append(':');
            buffer.append(value);
            buffer.append(';');
        }
        return buffer.toString();
    }

    public static String convertValueMap(Set<? extends UsageDescriptor> descriptors) {
        assert (descriptors != null);
        if (descriptors.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (UsageDescriptor usageDescriptor : descriptors) {
            int value = usageDescriptor.getValue();
            if (value == 0) continue;
            buffer.append(usageDescriptor.getKey());
            buffer.append("=");
            buffer.append(value);
            buffer.append(',');
        }
        if (buffer.length() == 0) {
            return "";
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String cutDataString(String patchStr, int maxSize2) {
        assert (patchStr != null);
        for (int i = maxSize2 - 1; i >= 0; --i) {
            char c = patchStr.charAt(i);
            if (c != ';' && c != ',') continue;
            return patchStr.substring(0, i);
        }
        return "";
    }

    public static StringPair getPair(String str, String separator) {
        assert (str != null);
        assert (separator != null);
        int i = str.indexOf(separator);
        if (i > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!ConvertUsagesUtil.isEmptyOrSpaces(key) && !ConvertUsagesUtil.isEmptyOrSpaces(value)) {
                return new StringPair(key, value);
            }
        }
        return null;
    }

    @NotNull
    public static String escapeDescriptorName(@NotNull String name) {
        return name.replace(':', '_').replace(';', '_').replace(',', '_').replace("'", " ").replace("\"", " ");
    }

    public static boolean isEmptyOrSpaces(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void assertDescriptorName(String key) {
        assert (key != null);
        assert (key.indexOf(58) == -1) : key + " contains invalid chars";
        assert (key.indexOf(59) == -1) : key + " contains invalid chars";
        assert (key.indexOf(44) == -1) : key + " contains invalid chars";
        assert (!key.contains("=")) : key + " contains invalid chars";
        assert (!key.contains("'")) : key + " contains invalid chars";
        assert (!key.contains("\"")) : key + " contains invalid chars";
    }

    public static String ensureProperKey(String input) {
        StringBuilder escaped = new StringBuilder();
        block3: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    escaped.append(' ');
                    continue block3;
                }
                default: {
                    escaped.append(ch);
                }
            }
        }
        return escaped.toString();
    }

    private static class StringPair {
        public final String first;
        public final String second;

        StringPair(String first, String second) {
            this.first = first;
            this.second = second;
        }
    }
}

