/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.beans;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UsageDescriptor {
    private final String myKey;
    private final int myValue;
    @NotNull
    private final FeatureUsageData myData;

    public UsageDescriptor(@NotNull String key) {
        this(key, 1);
    }

    public UsageDescriptor(@NotNull String key, int value) {
        this(key, value, new FeatureUsageData());
    }

    @Deprecated
    public UsageDescriptor(@NotNull String key, int value, String ... contextData) {
        this(key, value, contextData.length > 0 ? FUSUsageContext.create(contextData) : null);
    }

    @Deprecated
    public UsageDescriptor(@NotNull String key, int value, @Nullable FUSUsageContext context) {
        this(key, value);
        if (context != null) {
            this.myData.addFeatureContext(context);
        }
    }

    public UsageDescriptor(@NotNull String key, @Nullable FeatureUsageData data) {
        this(key, 1, data);
    }

    public UsageDescriptor(@NotNull String key, int value, @Nullable FeatureUsageData data) {
        this.myKey = ConvertUsagesUtil.ensureProperKey(key);
        this.myValue = value;
        this.myData = data;
    }

    public String getKey() {
        return this.myKey;
    }

    public int getValue() {
        return this.myValue;
    }

    @NotNull
    public FeatureUsageData getData() {
        return this.myData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageDescriptor that = (UsageDescriptor)o;
        return this.myValue == that.myValue && Objects.equals(this.myKey, that.myKey) && Objects.equals(this.myData, that.myData);
    }

    public int hashCode() {
        return Objects.hash(this.myKey, this.myValue, this.myData);
    }

    public String toString() {
        return this.myKey + "=" + this.myValue;
    }
}

