/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FacetTypeUsageCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        HashSet facets = ContainerUtil.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (Facet facet2 : FacetManager.getInstance((Module)module).getAllFacets()) {
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(facet2.getClass());
                facets.add(info.isDevelopedByJetBrains() ? facet2.getType().getStringId() : "third.party");
            }
        }
        return ContainerUtil.map2Set((Collection)facets, facet -> new UsageDescriptor((String)facet, 1));
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "module.facets";
    }
}

