/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.registry.Registry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RegistryApplicationUsagesCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        return RegistryApplicationUsagesCollector.getChangedValuesUsages();
    }

    @NotNull
    static Set<UsageDescriptor> getChangedValuesUsages() {
        Set registry = Registry.getAll().stream().filter(key -> key.isChangedFromDefault() && !key.isContributedByThirdPartyPlugin()).map(key -> new UsageDescriptor(key.getKey())).collect(Collectors.toSet());
        Set experiments = Arrays.stream(Experiments.EP_NAME.getExtensions()).filter(f -> PluginInfoDetectorKt.getPluginInfo(f.getClass()).isDevelopedByJetBrains()).filter(f -> Experiments.isFeatureEnabled((String)f.id)).map(f -> new UsageDescriptor(f.id)).collect(Collectors.toSet());
        HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>(registry);
        result2.addAll(experiments);
        return result2;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "platform.registry.application";
    }
}

