/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ActionsCollectorImpl
extends ActionsCollector
implements PersistentStateComponent<ActionsCollector.State> {
    private static final String GROUP = "actions";
    private static final String DEFAULT_ID = "third.party";
    private static final Set<String> ourCustomActionWhitelist = ContainerUtil.newHashSet((Object[])new String[]{"tooltip.actions.execute", "tooltip.actions.show.all", "tooltip.actions.show.description.gear", "tooltip.actions.show.description.shortcut", "tooltip.actions.show.description.morelink", "Ics.action.MergeSettings.text", "Ics.action.MergeSettings.text", "Ics.action.ResetToMySettings.text", "Reload Classes", "Progress Paused", "Progress Resumed", "DialogCancelAction", "DialogOkAction", "DoubleShortcut"});
    private final ActionsCollector.State myState = new ActionsCollector.State();

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        String recorded = StringUtil.isNotEmpty((String)actionId) && ourCustomActionWhitelist.contains(actionId) ? actionId : DEFAULT_ID;
        FeatureUsageData data = new FeatureUsageData().addOS();
        if (event instanceof KeyEvent) {
            data.addInputEvent((KeyEvent)event);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, recorded, data);
    }

    public void record(@Nullable Project project, @Nullable AnAction action, @Nullable AnActionEvent event) {
        if (action == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action.getClass());
        FeatureUsageData data = new FeatureUsageData().addOS().addProject(project).addPluginInfo(info);
        if (event != null) {
            data.addInputEvent(event).addPlace(event.getPlace()).addData("context_menu", event.isFromContextMenu());
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, ActionsCollectorImpl.toReportedId(info, action, data), data);
    }

    @NotNull
    public static String toReportedId(@NotNull PluginInfo info, @NotNull AnAction action, @NotNull FeatureUsageData data) {
        if (action instanceof ActionWithDelegate) {
            String parent = ActionsCollectorImpl.getActionId(info, action, true);
            data.addData("parent", parent);
            Object delegate = ((ActionWithDelegate)action).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate.getClass());
            return delegateInfo.isDevelopedByJetBrains() ? delegate.getClass().getName() : DEFAULT_ID;
        }
        return ActionsCollectorImpl.getActionId(info, action, false);
    }

    @NotNull
    private static String getActionId(@NotNull PluginInfo info, @NotNull AnAction action, boolean simpleName) {
        String actionId;
        if (!info.isDevelopedByJetBrains()) {
            return DEFAULT_ID;
        }
        String string = actionId = action.isGlobal() ? ActionManager.getInstance().getId(action) : null;
        if (actionId != null) {
            return ConvertUsagesUtil.escapeDescriptorName(actionId);
        }
        return simpleName ? action.getClass().getSimpleName() : action.getClass().getName();
    }

    @Nullable
    public ActionsCollector.State getState() {
        return this.myState;
    }

    public void loadState(@NotNull ActionsCollector.State state) {
    }
}

