/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="IntentionsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class IntentionsCollector
implements PersistentStateComponent<State> {
    private final State myState = new State();

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
    }

    public void record(@NotNull IntentionAction action, @NotNull Language language) {
        this.record(null, action, language);
    }

    public void record(@Nullable Project project, @NotNull IntentionAction action, @NotNull Language language) {
        Class clazz = IntentionsCollector.getOriginalHandlerClass(action);
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(clazz);
        FeatureUsageData data = new FeatureUsageData().addOS().addProject(project).addPluginInfo(info).addLanguage(language);
        String id = info.isSafeToReport() ? IntentionsCollector.toReportedId(clazz) : "third.party.intention";
        FUCounterUsageLogger.getInstance().logEvent("intentions", id, data);
    }

    @NotNull
    private static Class getOriginalHandlerClass(@NotNull IntentionAction action) {
        LocalQuickFix fix;
        IntentionAction handler2 = action;
        if (action instanceof IntentionActionDelegate) {
            IntentionAction delegate = ((IntentionActionDelegate)action).getDelegate();
            if (delegate != action) {
                return IntentionsCollector.getOriginalHandlerClass(delegate);
            }
        } else if (action instanceof QuickFixWrapper && (fix = ((QuickFixWrapper)action).getFix()) != action) {
            handler2 = fix;
        }
        return handler2.getClass();
    }

    @NotNull
    private static String toReportedId(Class<?> clazz) {
        return clazz.getName();
    }

    public static IntentionsCollector getInstance() {
        return (IntentionsCollector)ServiceManager.getService(IntentionsCollector.class);
    }

    public static final class State {
        @Tag(value="Intentions")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="name", valueAttributeName="count")
        public Map<String, Integer> myIntentions = new HashMap<String, Integer>();
    }
}

