/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="MainMenuCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="statistics.main_menu.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class MainMenuCollector
implements PersistentStateComponent<State> {
    private final State myState = new State();

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
    }

    public void record(@NotNull AnAction action) {
        try {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action.getClass());
            if (!info.isDevelopedByJetBrains()) {
                return;
            }
            AWTEvent e = EventQueue.getCurrentEvent();
            String path = null;
            if (e instanceof ItemEvent) {
                path = this.getPathFromMenuItem(e, action);
            } else if (e instanceof MouseEvent) {
                path = this.getPathFromMenuSelectionManager(action);
            }
            if (!StringUtil.isEmpty((String)path)) {
                FeatureUsageData featureUsageData = new FeatureUsageData().addOS().addPluginInfo(info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getPathFromMenuSelectionManager(@NotNull AnAction action) {
        List<String> groups = Arrays.stream(MenuSelectionManager.defaultManager().getSelectedPath()).filter(o -> o instanceof ActionMenu).map(o -> ((ActionMenu)((Object)((Object)o))).getAnAction().getTemplateText()).collect(Collectors.toList());
        if (groups.size() > 0) {
            String text = MainMenuCollector.getActionText(action);
            groups.add(text);
            return MainMenuCollector.convertMenuItemsToKey(groups);
        }
        return null;
    }

    private static String getActionText(@NotNull AnAction action) {
        String actionId = ActionManager.getInstance().getId(action);
        if (StringUtil.isEmpty((String)actionId)) {
            return "generated.on.runtime";
        }
        return action.getTemplateText();
    }

    @NotNull
    private static String convertMenuItemsToKey(List<String> menuItems) {
        return StringUtil.join(menuItems, (String)" -> ");
    }

    @NotNull
    protected String getPathFromMenuItem(AWTEvent e, AnAction action) {
        Object src = e.getSource();
        ArrayList<String> items = new ArrayList<String>();
        while (src instanceof MenuItem) {
            items.add(0, ((MenuItem)src).getLabel());
            src = ((MenuItem)src).getParent();
        }
        if (items.size() > 1) {
            items.set(items.size() - 1, MainMenuCollector.getActionText(action));
        }
        return MainMenuCollector.convertMenuItemsToKey(items);
    }

    public static MainMenuCollector getInstance() {
        return (MainMenuCollector)ServiceManager.getService(MainMenuCollector.class);
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="path", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

