/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ShortcutsCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowWhitelistEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ToolWindowsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ToolWindowCollector
implements PersistentStateComponent<State> {
    public static final Map<String, PluginInfo> ourToolwindowWhitelist = new HashMap<String, PluginInfo>();
    private final State myState = new State();

    public static ToolWindowCollector getInstance() {
        return (ToolWindowCollector)ServiceManager.getService(ToolWindowCollector.class);
    }

    public ToolWindowCollector() {
        for (ToolWindowWhitelistEP extension : (ToolWindowWhitelistEP[])ToolWindowWhitelistEP.EP_NAME.getExtensions()) {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfoById(extension.getPluginId());
            if (!info.isDevelopedByJetBrains()) continue;
            ourToolwindowWhitelist.put(extension.id, info);
        }
        ShortcutsCollector.getInstance();
        OutdatedToolWindowCollector.getInstance();
    }

    public void recordActivation(String toolWindowId) {
        this.record(toolWindowId, ToolWindowActivationSource.ACTIVATION);
    }

    public void recordClick(String toolWindowId) {
        this.record(toolWindowId, ToolWindowActivationSource.CLICK);
    }

    private void record(@Nullable String toolWindowId, @NotNull ToolWindowActivationSource source) {
        if (toolWindowId == null) {
            return;
        }
        PluginInfo info = ToolWindowCollector.getPluginInfo(toolWindowId);
        String key = ConvertUsagesUtil.escapeDescriptorName(info.isDevelopedByJetBrains() ? toolWindowId : "unknown");
        FeatureUsageData data = new FeatureUsageData().addOS().addPluginInfo(info);
        if (source != ToolWindowActivationSource.ACTIVATION) {
            data.addData("source", StringUtil.toLowerCase((String)source.name()));
        }
        FUCounterUsageLogger.getInstance().logEvent("toolwindow", key, data);
    }

    @NotNull
    private static PluginInfo getPluginInfo(@NotNull String toolWindowId) {
        if (ourToolwindowWhitelist.containsKey(toolWindowId)) {
            return ourToolwindowWhitelist.get(toolWindowId);
        }
        PluginInfo info = ToolWindowCollector.getPluginInfo(toolWindowId, (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions());
        if (info == null) {
            info = ToolWindowCollector.getPluginInfo(toolWindowId, (ToolWindowEP[])LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        if (info == null) {
            info = ToolWindowCollector.getPluginInfo(toolWindowId, (ToolWindowEP[])FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        return info != null ? info : PluginInfoDetectorKt.getUnknownPlugin();
    }

    @Nullable
    public static PluginInfo getPluginInfo(@NotNull String toolWindowId, @NotNull ToolWindowEP[] toolWindows) {
        for (ToolWindowEP ep : toolWindows) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)ep.id)) continue;
            return PluginInfoDetectorKt.getPluginInfoById(ep.getPluginId());
        }
        return null;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
    }

    static {
        ourToolwindowWhitelist.put(ToolWindowId.COMMANDER, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.MESSAGES_WINDOW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.PROJECT_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.STRUCTURE_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.FAVORITES_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.ANT_BUILD, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DEBUG, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.RUN, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.BUILD, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.FIND, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.CVS, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.HIERARCHY, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.INSPECTION, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.TODO_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DEPENDENCIES, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.VCS, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.MODULES_DEPENDENCIES, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DUPLICATES, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.EXTRACT_METHOD, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DOCUMENTATION, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.TASKS, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.DATABASE_VIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.PREVIEW, PluginInfoDetectorKt.getPlatformPlugin());
        ourToolwindowWhitelist.put(ToolWindowId.RUN_DASHBOARD, PluginInfoDetectorKt.getPlatformPlugin());
    }

    @com.intellij.openapi.components.State(name="ToolWindowCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
    public static class OutdatedToolWindowCollector
    implements PersistentStateComponent<State> {
        public static OutdatedToolWindowCollector getInstance() {
            return (OutdatedToolWindowCollector)ServiceManager.getService(OutdatedToolWindowCollector.class);
        }

        @Nullable
        public State getState() {
            return new State();
        }

        public void loadState(@NotNull State state) {
        }
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="toolWindow", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }

    static enum ToolWindowActivationSource {
        ACTIVATION,
        CLICK;

    }
}

