/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class FileTypeExtensionUsagesCollectorStartupActivity
implements StartupActivity,
DumbAware {
    private static final Key<Long> LAST_EDIT_USAGE = Key.create((String)"LAST_EDIT_USAGE");

    public void runActivity(final @NotNull Project project) {
        MessageBusConnection myConnection = project.getMessageBus().connect();
        myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                FileTypeUsageCounterCollector.triggerOpen(project, file2);
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action instanceof EditorAction && ((EditorAction)action).getHandler() instanceof EditorWriteActionHandler) {
                    this.onChange(dataContext);
                }
            }

            private void onChange(DataContext dataContext) {
                Long lastEdit;
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                if (editor == null || editor.getProject() != project) {
                    return;
                }
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
                if (file2 != null && ((lastEdit = (Long)editor.getUserData(LAST_EDIT_USAGE)) == null || System.currentTimeMillis() - lastEdit > 60000L)) {
                    editor.putUserData(LAST_EDIT_USAGE, (Object)System.currentTimeMillis());
                    FileTypeUsageCounterCollector.triggerEdit(project, file2);
                }
            }

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                this.onChange(dataContext);
            }
        });
    }
}

