/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LazyInstance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;

public class FileTypeUsageCounterCollector {
    private static final Logger LOG = Logger.getInstance((String)("#" + FileTypeUsageCounterCollector.class.getPackage().getName()));
    private static final ExtensionPointName<FileTypeUsageSchemaDescriptorEP<FileTypeUsageSchemaDescriptor>> EP = ExtensionPointName.create((String)"com.intellij.fileTypeUsageSchemaDescriptor");

    public static void triggerEdit(@NotNull Project project, @NotNull VirtualFile file2) {
        FileTypeUsageCounterCollector.trigger(project, file2, "edit");
    }

    public static void triggerOpen(@NotNull Project project, @NotNull VirtualFile file2) {
        FileTypeUsageCounterCollector.trigger(project, file2, "open");
    }

    private static void trigger(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String type) {
        FeatureUsageData data = new FeatureUsageData().addData("type", type);
        FileType fileType = file2.getFileType();
        for (FileTypeUsageSchemaDescriptorEP ext : EP.getExtensionList()) {
            FileTypeUsageSchemaDescriptor instance = (FileTypeUsageSchemaDescriptor)ext.getInstance();
            if (ext.schema == null) {
                LOG.warn("Extension " + ext.implementationClass + " should define a 'schema' attribute");
                continue;
            }
            if (!instance.describes(file2)) continue;
            data.addData("schema", StatisticsUtilKt.getPluginType(instance.getClass()).isSafeToReport() ? ext.schema : "third.party");
            break;
        }
        String id = FileTypeUsagesCollector.toReportedId(fileType, data);
        FUCounterUsageLogger.getInstance().logEvent(project, "file.types.usage", id, data);
    }

    public static class FileTypeUsageSchemaDescriptorEP<T>
    extends AbstractExtensionPointBean
    implements KeyedLazyInstance<T> {
        @Attribute(value="schema")
        public String schema;
        @Attribute(value="implementationClass")
        public String implementationClass;
        private final LazyInstance<T> myHandler = new LazyInstance<T>(){

            protected Class<T> getInstanceClass() throws ClassNotFoundException {
                return this.findClass(implementationClass);
            }
        };

        @NotNull
        public T getInstance() {
            return (T)this.myHandler.getValue();
        }

        public String getKey() {
            return this.schema;
        }
    }
}

