/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String DEFAULT_ID = "third.party";

    @Override
    @NotNull
    public String getGroupId() {
        return "file.types";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        return FileTypeUsagesCollector.getDescriptors(project);
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors(@NotNull Project project) {
        FileType[] registeredFileTypes;
        HashSet<UsageDescriptor> descriptors = new HashSet<UsageDescriptor>();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            return Collections.emptySet();
        }
        for (FileType fileType : registeredFileTypes = fileTypeManager.getRegisteredFileTypes()) {
            if (project.isDisposed()) {
                return Collections.emptySet();
            }
            FeatureUsageData data = new FeatureUsageData();
            String id = FileTypeUsagesCollector.toReportedId(fileType, data);
            ApplicationManager.getApplication().runReadAction(() -> FileTypeIndex.processFiles(fileType, (Processor<? super VirtualFile>)((Processor)file2 -> {
                if (!ProjectKt.getStateStore(project).isProjectFile((VirtualFile)file2)) {
                    descriptors.add(new UsageDescriptor(id, 1, data));
                    return false;
                }
                return true;
            }), GlobalSearchScope.projectScope((Project)project)));
        }
        return descriptors;
    }

    @NotNull
    public static String toReportedId(@NotNull FileType type, @NotNull FeatureUsageData data) {
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(type.getClass());
        data.addPluginInfo(info);
        return info.isDevelopedByJetBrains() ? type.getName() : DEFAULT_ID;
    }
}

