/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JpsElementPropertiesSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

public class ProjectStructureUsageCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        Module[] modules;
        Map typeNames = JBIterable.from((Iterable)JpsModelSerializerExtension.getExtensions()).filter(o -> PluginInfoDetectorKt.getPluginInfo(o.getClass()).isDevelopedByJetBrains()).flatMap(JpsModelSerializerExtension::getModuleSourceRootPropertiesSerializers).toMap(JpsElementPropertiesSerializer::getType, JpsElementPropertiesSerializer::getTypeId);
        boolean packagePrefixUsed = false;
        int contentRoots = 0;
        int sourceRoots = 0;
        int excludedRoots = 0;
        TObjectIntHashMap types = new TObjectIntHashMap();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            contentRoots += rootManager.getContentEntries().length;
            sourceRoots += rootManager.getSourceRoots(true).length;
            excludedRoots += rootManager.getExcludeRoots().length;
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder source : entry.getSourceFolders()) {
                    packagePrefixUsed = packagePrefixUsed || StringUtil.isNotEmpty((String)source.getPackagePrefix());
                    String key2 = (String)typeNames.get(source.getRootType());
                    if (key2 == null || types.increment((Object)key2)) continue;
                    types.put((Object)key2, 1);
                }
            }
        }
        HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>();
        result2.add(StatisticsUtilKt.getCountingUsage("modules.count", modules.length));
        result2.add(StatisticsUtilKt.getCountingUsage("content.roots.count", contentRoots));
        result2.add(StatisticsUtilKt.getCountingUsage("source.roots.count", sourceRoots));
        result2.add(StatisticsUtilKt.getCountingUsage("excluded.roots.count", excludedRoots));
        types.forEachEntry((key, count) -> result2.add(StatisticsUtilKt.getCountingUsage("source.root." + key, count)));
        if (PlatformUtils.isIntelliJ()) {
            result2.add(new UsageDescriptor(packagePrefixUsed ? "package.prefix.used" : "package.prefix.not.used"));
        }
        return result2;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "project.structure";
    }
}

