/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OsVersionUsageCollector {
    private static final Set<String> ourReleases = ContainerUtil.newHashSet((Object[])new String[]{"alpine", "amzn", "antergos", "arch", "centos", "debian", "deepin", "elementary", "fedora", "galliumos", "gentoo", "kali", "linuxmint", "manjaro", "neon", "nixos", "ol", "opensuse", "opensuse-leap", "opensuse-tumbleweed", "freedesktop", "parrot", "raspbian", "rhel", "sabayon", "solus", "ubuntu", "zorin"});

    @NotNull
    public static LinuxRelease getLinuxRelease() {
        String releaseId = null;
        String releaseVersion = null;
        try (Stream<String> lines2 = Files.lines(Paths.get("/etc/os-release", new String[0]));){
            Map<String, String> releases = lines2.map(line -> StringUtil.split((String)line, (String)"=")).filter(parts -> parts.size() == 2).collect(Collectors.toMap(parts -> (String)parts.get(0), parts -> StringUtil.unquoteString((String)((String)parts.get(1)))));
            releaseId = releases.get("ID");
            releaseVersion = releases.get("VERSION_ID");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new LinuxRelease(OsVersionUsageCollector.parseName(releaseId), releaseVersion != null ? releaseVersion : SystemInfo.OS_VERSION);
    }

    @Nullable
    public static Version parse(@Nullable String releaseVersion) {
        return releaseVersion != null ? Version.parseVersion((String)releaseVersion.trim()) : null;
    }

    @NotNull
    private static String parseName(@Nullable String releaseId) {
        if (releaseId == null) {
            return "unknown";
        }
        String release2 = StringUtil.trimStart((String)StringUtil.toLowerCase((String)releaseId).trim(), (String)"org.");
        int separator = release2.indexOf(".");
        if (separator > 0) {
            release2 = release2.substring(0, separator);
        }
        if (ourReleases.contains(release2)) {
            return release2;
        }
        return "custom";
    }

    public static class LinuxRelease {
        @NotNull
        private final String myRelease;
        @Nullable
        private final String myVersion;

        public LinuxRelease(@NotNull String release2, @Nullable String version2) {
            this.myRelease = release2;
            this.myVersion = version2;
        }

        @NotNull
        public String getRelease() {
            return this.myRelease;
        }

        @Nullable
        public String getVersion() {
            return this.myVersion;
        }
    }
}

