/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.plugins;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NonBundledPluginsUsagesCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public String getGroupId() {
        return "plugins.non.bundled";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        Object[] plugins2 = PluginManagerCore.getPlugins();
        List nonBundledEnabledPlugins = ContainerUtil.filter((Object[])plugins2, d -> d.isEnabled() && !d.isBundled() && StatisticsUtilKt.isSafeToReportFrom(d));
        return ContainerUtil.map2Set((Collection)nonBundledEnabledPlugins, descriptor -> new UsageDescriptor(descriptor.getPluginId().getIdString(), 1));
    }
}

