/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorSchemesUsagesCollector
extends ApplicationUsagesCollector {
    public static final String SCHEME_NAME_OTHER = "Other";
    public static final String[] KNOWN_NAMES = new String[]{"Obsidian", "Visual Studio", "Solarized", "Wombat", "Monkai", "XCode", "Sublime", "Oblivion", "Zenburn", "Cobalt", "Netbeans", "Eclipse", "Aptana", "Flash Builder"};

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        return EditorColorSchemesUsagesCollector.getDescriptors();
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors() {
        EditorColorsScheme currentScheme = EditorColorsManager.getInstance().getGlobalScheme();
        HashSet usages = ContainerUtil.newHashSet();
        String schemeName = SCHEME_NAME_OTHER;
        if (currentScheme instanceof AbstractColorsScheme) {
            AbstractColorsScheme original;
            String name = currentScheme.getName();
            if (name.startsWith("_@user_") && (original = ((AbstractColorsScheme)currentScheme).getOriginal()) != null) {
                schemeName = original.getName();
            }
            if (schemeName == SCHEME_NAME_OTHER) {
                String knownName = EditorColorSchemesUsagesCollector.getKnownSchemeName(name);
                if (knownName != null) {
                    schemeName = knownName;
                }
                boolean isDark = ColorUtil.isDark((Color)currentScheme.getDefaultBackground());
                schemeName = schemeName + "[" + (isDark ? "Dark" : "Light") + "]";
            }
            usages.add(new UsageDescriptor(schemeName, 1));
        }
        return usages;
    }

    @Nullable
    private static String getKnownSchemeName(@NonNls @NotNull String schemeName) {
        for (String knownName : KNOWN_NAMES) {
            if (!schemeName.toUpperCase().contains(knownName.toUpperCase())) continue;
            return knownName;
        }
        return null;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "ui.editor.color.schemes";
    }

    @Override
    @Nullable
    public FeatureUsageData getData() {
        return new FeatureUsageData().addOS();
    }
}

