/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.jdkEx.JdkEx;
import com.intellij.util.ui.JBUI;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ScaleInfoUsageCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        return ScaleInfoUsageCollector.getDescriptors();
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors() {
        int scaleBase;
        float scale = JBUI.sysScale();
        float scaleFract = scale - (float)(scaleBase = (int)Math.floor(scale));
        scaleFract = scaleFract == 0.0f ? 0.0f : (scaleFract < 0.375f ? 0.25f : (scaleFract < 0.625f ? 0.5f : 0.75f));
        scale = (float)scaleBase + scaleFract;
        String prefix = "";
        if (!GraphicsEnvironment.isHeadless()) {
            DisplayMode dm = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
            if (JdkEx.getDisplayModeEx().isDefault(dm)) {
                prefix = prefix + "ScaledMode_";
            }
        }
        String key = prefix.length() == 0 ? String.valueOf(scale) : prefix + scale;
        return Collections.singleton(new UsageDescriptor(key, 1, new FeatureUsageData().addOS()));
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "ui.screen.scale";
    }
}

