/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInfoUsageCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        return UiInfoUsageCollector.getDescriptors();
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors() {
        THashSet set2 = new THashSet();
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Nav.Bar.visible", UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Nav.Bar.floating", UiInfoUsageCollector.navbar() ? 0 : 1);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Toolbar.visible", UiInfoUsageCollector.toolbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Toolbar.hidden", UiInfoUsageCollector.toolbar() ? 0 : 1);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Toolbar.and.NavBar", !UiInfoUsageCollector.toolbar() && UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Toolbar.and.NavBar.hidden", !UiInfoUsageCollector.toolbar() && !UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Status.bar.visible", UiInfoUsageCollector.status() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Status.bar.hidden", UiInfoUsageCollector.status() ? 0 : 1);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Tool.Window.buttons.visible", UiInfoUsageCollector.stripes() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Tool.Window.buttons.hidden", UiInfoUsageCollector.stripes() ? 0 : 1);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Recent.Files[15]", UiInfoUsageCollector.recent() == 15 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Recent.Files[15_30]", 15 < UiInfoUsageCollector.recent() && UiInfoUsageCollector.recent() < 31 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Recent.Files[30_50]", 30 < UiInfoUsageCollector.recent() && UiInfoUsageCollector.recent() < 51 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Recent.Files[more.than.50]", 50 < UiInfoUsageCollector.recent() ? 1 : 0);
        set2.add(new UsageDescriptor("recent.files", 1, new FeatureUsageData().addData("grouped", UiInfoUsageCollector.recentPeriod(UiInfoUsageCollector.recent()))));
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Block.cursor", EditorSettingsExternalizable.getInstance().isBlockCursor() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Line.Numbers", EditorSettingsExternalizable.getInstance().isLineNumbersShown() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Gutter.Icons", EditorSettingsExternalizable.getInstance().areGutterIconsShown() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Soft.Wraps", EditorSettingsExternalizable.getInstance().isUseSoftWraps() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Tabs.None", UiInfoUsageCollector.tabPlace() == 0 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Tabs.Top", UiInfoUsageCollector.tabPlace() == 1 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Tabs.Bottom", UiInfoUsageCollector.tabPlace() == 3 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Tabs.Left", UiInfoUsageCollector.tabPlace() == 2 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Tabs.Right", UiInfoUsageCollector.tabPlace() == 4 ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Retina", UIUtil.isRetina() ? 1 : 0);
        UiInfoUsageCollector.add((Set<UsageDescriptor>)set2, "Show.tips.on.startup", GeneralSettings.getInstance().isShowTipsOnStartup() ? 1 : 0);
        set2.add(StatisticsUtilKt.getBooleanUsage("Allow.merging.buttons", UISettings.getInstance().getAllowMergeButtons()));
        return set2;
    }

    private static String recentPeriod(int recent) {
        if (recent < 15) {
            return "less.than.15";
        }
        if (16 < recent && recent < 31) {
            return "[15_30]";
        }
        if (30 < recent && recent < 51) {
            return "[30_50]";
        }
        return "[more.than.50]";
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "ui.info.features";
    }

    private static void add(Set<UsageDescriptor> set2, String key, int value) {
        set2.add(new UsageDescriptor(key, value));
    }

    private static int tabPlace() {
        return UISettings.getInstance().getEditorTabPlacement();
    }

    private static int recent() {
        return UISettings.getInstance().getRecentFilesLimit();
    }

    private static boolean stripes() {
        return UISettings.getInstance().getHideToolStripes();
    }

    private static boolean status() {
        return UISettings.getInstance().getShowStatusBar();
    }

    private static boolean toolbar() {
        return UISettings.getInstance().getShowMainToolbar();
    }

    private static boolean navbar() {
        return UISettings.getInstance().getShowNavigationBar();
    }

    @Override
    @Nullable
    public FeatureUsageData getData() {
        return new FeatureUsageData().addOS();
    }
}

