/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui.persistence;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@State(name="ToolbarClicksCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="statistics.toolbar.clicks.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ToolbarClicksCollector
implements PersistentStateComponent<ClicksState> {
    private final ClicksState myState = new ClicksState();

    public ClicksState getState() {
        return this.myState;
    }

    public void loadState(@NotNull ClicksState state) {
    }

    public static void record(@NotNull AnAction action, String place) {
        ToolbarClicksCollector collector = ToolbarClicksCollector.getInstance();
        if (collector != null) {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action.getClass());
            FeatureUsageData data = new FeatureUsageData().addPluginInfo(info).addOS().addPlace(place);
            FUCounterUsageLogger.getInstance().logEvent("toolbar", ActionsCollectorImpl.toReportedId(info, action, data), data);
        }
    }

    public static ToolbarClicksCollector getInstance() {
        return (ToolbarClicksCollector)ServiceManager.getService(ToolbarClicksCollector.class);
    }

    public static final class ClicksState {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="action", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

