/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

class EditorSettingsStatisticsCollector
extends ApplicationUsagesCollector {
    EditorSettingsStatisticsCollector() {
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "editor.settings.ide";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        HashSet<UsageDescriptor> set2 = new HashSet<UsageDescriptor>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsExternalizable esDefault = new EditorSettingsExternalizable();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVirtualSpace(), "caretAfterLineEnd");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCaretInsideTabs(), "caretInsideTabs");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAdditionalPageAtBottom(), "virtualSpaceAtFileBottom");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), "softWraps");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), "softWraps.console");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), "softWraps.preview");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseCustomSoftWrapIndent(), "softWraps.relativeIndent");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAllSoftWrapsShown(), "softWraps.showAll");
        StatisticsUtilKt.addIfDiffers(set2, es, esDefault, s -> s.getStripTrailingSpaces(), "stripTrailingSpaces");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isEnsureNewLineAtEOF(), "ensureNewlineAtEOF");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowQuickDocOnMouseOverElement(), "quickDocOnMouseHover");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlinkCaret(), "blinkingCaret");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlockCursor(), "blockCaret");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRightMarginShown(), "rightMargin");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isLineNumbersShown(), "lineNumbers");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.areGutterIconsShown(), "gutterIcons");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isFoldingOutlineShown(), "foldingOutline");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isLeadingWhitespacesShown(), "showLeadingWhitespace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isInnerWhitespacesShown(), "showInnerWhitespace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isTrailingWhitespacesShown(), "showTrailingWhitespace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isIndentGuidesShown(), "indentGuides");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmoothScrolling(), "animatedScroll");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isDndEnabled(), "dragNDrop");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWheelFontChangeEnabled(), "wheelZoom");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isMouseClickSelectionHonorsCamelWords(), "mouseCamel");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVariableInplaceRenameEnabled(), "inplaceRename");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isPreselectRename(), "preselectOnRename");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowInlineLocalDialog(), "inlineDialog");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRefrainFromScrolling(), "minimizeScrolling");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION, "afterReformatNotification");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION, "afterOptimizeNotification");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmartHome(), "smartHome");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCamelWords(), "camelWords");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowParameterNameHints(), "editor.inlay.parameter.hints");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsAbove(), "noBreadcrumbsBelow");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsShown(), "breadcrumbs");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowIntentionBulb(), "intentionBulb");
        RichCopySettings rcs = RichCopySettings.getInstance();
        RichCopySettings rcsDefault = new RichCopySettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, rcs, rcsDefault, s -> s.isEnabled(), "richCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        CodeInsightSettings cisDefault = new CodeInsightSettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_PARAMETER_INFO, "parameterAutoPopup");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_JAVADOC_INFO, "javadocAutoPopup");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_COMPLETION_LOOKUP, "completionAutoPopup");
        StatisticsUtilKt.addIfDiffers(set2, cis, cisDefault, s -> s.COMPLETION_CASE_SENSITIVE, "completionCaseSensitivity");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.isSelectAutopopupSuggestionsByChars(), "autoPopupCharComplete");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_CODE_COMPLETION, "autoCompleteBasic");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, "autoCompleteSmart");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, "parameterInfoFullSignature");
        StatisticsUtilKt.addIfDiffers(set2, cis, cisDefault, s -> s.getBackspaceMode(), "smartBackspace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_INDENT_ON_ENTER, "indentOnEnter");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.INSERT_BRACE_ON_ENTER, "braceOnEnter");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_STUB_ON_ENTER, "javadocOnEnter");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_END_ACTION, "smartEnd");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_GENERATE_CLOSING_TAG, "autoCloseJavadocTags");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SURROUND_SELECTION_ON_QUOTE_TYPED, "surroundByQuoteOrBrace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_BRACKET, "pairBracketAutoInsert");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_QUOTE, "pairQuoteAutoInsert");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_BLOCK_ON_RBRACE, "reformatOnRBrace");
        StatisticsUtilKt.addIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_ON_PASTE, "reformatOnPaste");
        StatisticsUtilKt.addIfDiffers(set2, cis, cisDefault, s -> s.ADD_IMPORTS_ON_PASTE, "importsOnPaste");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_BRACES, "bracesHighlight");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_SCOPE, "scopeHighlight");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_IDENTIFIER_UNDER_CARET, "identifierUnderCaretHighlight");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, "autoAddImports");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION, "completionHints");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_EXTERNAL_ANNOTATIONS_INLINE, "externalAnnotationsInline");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_INFERRED_ANNOTATIONS_INLINE, "inferredAnnotationsInline");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.TAB_EXITS_BRACKETS_AND_QUOTES, "tabExitsBracketsAndQuotes");
        return set2;
    }

    private static <T> void addBoolIfDiffers(Set<UsageDescriptor> set2, T settingsBean, T defaultSettingsBean, Function1<T, Boolean> valueFunction, String featureId) {
        StatisticsUtilKt.addIfDiffers(set2, settingsBean, defaultSettingsBean, valueFunction, it -> it != false ? featureId : "no" + StringUtil.capitalize((String)featureId));
    }

    public static class ProjectUsages
    extends ProjectUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            return "editor.settings.project";
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project project) {
            HashSet<UsageDescriptor> set2 = new HashSet<UsageDescriptor>();
            CodeInsightWorkspaceSettings ciws = CodeInsightWorkspaceSettings.getInstance(project);
            CodeInsightWorkspaceSettings ciwsDefault = new CodeInsightWorkspaceSettings();
            EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, ciws, ciwsDefault, s -> s.optimizeImportsOnTheFly, "autoOptimizeImports");
            return set2;
        }
    }
}

