/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\f\u0010\u001b\u001a\u00020\u000b*\u00020\u0006H\u0002J\f\u0010\u001c\u001a\u00020\u0006*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u0006*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SALT_PREFERENCE_KEY", "", "anonymizedCache", "Ljava/util/HashMap;", "kotlin.jvm.PlatformType", "bucket", "", "getBucket", "()I", "build", "getBuild", "()Ljava/lang/String;", "deviceId", "getDeviceId", "salt", "", "sessionId", "getSessionId", "version", "anonymize", "data", "getOrGenerateSalt", "asBucket", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "shortedUUID", "intellij.platform.ide.impl"})
public final class EventLogConfiguration {
    private static final Logger LOG;
    private static final String SALT_PREFERENCE_KEY = "feature_usage_event_log_salt";
    public static final int version = 11;
    @NotNull
    private static final String sessionId;
    @NotNull
    private static final String deviceId;
    private static final int bucket;
    @NotNull
    private static final String build;
    private static final byte[] salt;
    private static final HashMap<String, String> anonymizedCache;
    public static final EventLogConfiguration INSTANCE;

    @NotNull
    public final String getSessionId() {
        return sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return deviceId;
    }

    public final int getBucket() {
        return bucket;
    }

    @NotNull
    public final String getBuild() {
        return build;
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        if (StringUtil.isEmptyOrSpaces((String)data)) {
            return data;
        }
        if (anonymizedCache.containsKey(data)) {
            String string = anonymizedCache.get(data);
            if (string == null) {
                string = "";
            }
            return string;
        }
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putBytes(salt);
        hasher.putString((CharSequence)data, StandardCharsets.UTF_8);
        String result2 = hasher.hash().toString();
        Map map2 = anonymizedCache;
        String string = result2;
        map2.put(data, string);
        return result2;
    }

    private final String shortedUUID(@NotNull String $receiver) {
        int start2 = StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start2 > 0 && start2 + 1 < $receiver.length()) {
            String string = $receiver;
            int n = start2 + 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $receiver;
    }

    private final String asBuildNumber(@NotNull BuildNumber $receiver) {
        String str = $receiver.asStringWithoutProductCodeAndSnapshot();
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    private final int asBucket(@NotNull String $receiver) {
        return Math.abs($receiver.hashCode()) % 256;
    }

    private final byte[] getOrGenerateSalt() {
        String string;
        String companyName = ApplicationInfoImpl.getShadowInstance().getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string2 = companyName;
            Locale locale = Locale.US;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        Preferences prefs = Preferences.userRoot().node(name);
        byte[] salt = prefs.getByteArray(SALT_PREFERENCE_KEY, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(SALT_PREFERENCE_KEY, salt);
            LOG.info("Generating salt for the device");
        }
        return salt;
    }

    private EventLogConfiguration() {
    }

    static {
        EventLogConfiguration eventLogConfiguration;
        INSTANCE = eventLogConfiguration = new EventLogConfiguration();
        LOG = Logger.getInstance(EventLogConfiguration.class);
        sessionId = eventLogConfiguration.shortedUUID(UUID.randomUUID().toString());
        deviceId = DeviceIdManager.INSTANCE.getOrGenerateId();
        bucket = eventLogConfiguration.asBucket(deviceId);
        build = eventLogConfiguration.asBuildNumber(ApplicationInfo.getInstance().getBuild());
        salt = eventLogConfiguration.getOrGenerateSalt();
        anonymizedCache = ContainerUtil.newHashMap();
    }
}

