/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.connect.StatServiceException;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogStatisticsService
implements StatisticsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.EventLogStatisticsService");
    private static final EventLogSettingsService mySettingsService = EventLogExternalSettingsService.getInstance();
    private static final int MAX_FILES_TO_SEND = 20;

    @Override
    public StatisticsResult send() {
        return EventLogStatisticsService.send(mySettingsService, new EventLogCounterResultDecorator());
    }

    public static StatisticsResult send(@NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        if (!FeatureUsageLogger.INSTANCE.isEnabled() || !StatisticsUploadAssistant.isSendAllowed()) {
            EventLogStatisticsService.cleanupAllFiles();
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "Event Log collector is not enabled");
        }
        List logs = FeatureUsageLogger.INSTANCE.getLogFiles();
        if (logs.isEmpty()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to send");
        }
        String serviceUrl = settings.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        if (!EventLogStatisticsService.isSendLogsEnabled(settings.getPermittedTraffic())) {
            EventLogStatisticsService.cleanupAllFiles();
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        LogEventFilter filter = settings.getEventFilter();
        try {
            ArrayList<File> toRemove2 = new ArrayList<File>(logs.size());
            int size = Math.min(20, logs.size());
            for (int i = 0; i < size; ++i) {
                File file2 = (File)logs.get(i);
                LogEventRecordRequest recordRequest = LogEventRecordRequest.Companion.create(file2, filter, settings.isInternal());
                String error = EventLogStatisticsService.validate(recordRequest, file2);
                if (StringUtil.isNotEmpty((String)error) || recordRequest == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(file2.getName() + "-> " + error);
                    }
                    decorator.failed(recordRequest);
                    toRemove2.add(file2);
                    continue;
                }
                try {
                    HttpRequests.post((String)serviceUrl, (String)"application/json; charset=utf-8").isReadResponseOnError(true).tuner(connection -> connection.setRequestProperty("Content-Encoding", "gzip")).connect(request -> {
                        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                        try (OutputStreamWriter writer = new OutputStreamWriter(new GZIPOutputStream((OutputStream)out));){
                            LogEventSerializer.INSTANCE.toString(recordRequest, writer);
                        }
                        request.write(out.toByteArray());
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(file2.getName() + " -> " + EventLogStatisticsService.readResponse(request));
                        }
                        return null;
                    });
                    decorator.succeed(recordRequest);
                    toRemove2.add(file2);
                    continue;
                }
                catch (HttpRequests.HttpStatusException e) {
                    decorator.failed(recordRequest);
                    if (e.getStatusCode() == 400) {
                        toRemove2.add(file2);
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(file2.getName() + " -> " + e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(file2.getName() + " -> " + e.getMessage());
                }
            }
            EventLogStatisticsService.cleanupFiles(toRemove2);
            return decorator.toResult();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    @Nullable
    private static String readResponse(@NotNull HttpRequests.Request request) {
        try {
            return request.readString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static boolean isSendLogsEnabled(int percent) {
        if (percent == 0) {
            return false;
        }
        return (double)EventLogConfiguration.INSTANCE.getBucket() < (double)percent * 2.56;
    }

    @Nullable
    private static String validate(@Nullable LogEventRecordRequest request, @NotNull File file2) {
        if (request == null) {
            return "File is empty or has invalid format: " + file2.getName();
        }
        if (StringUtil.isEmpty((String)request.getDevice())) {
            return "Cannot upload event log, device ID is empty";
        }
        if (StringUtil.isEmpty((String)request.getProduct())) {
            return "Cannot upload event log, product code is empty";
        }
        if (StringUtil.isEmpty((String)request.getRecorder())) {
            return "Cannot upload event log, recorder code is empty";
        }
        if (request.getRecords().isEmpty()) {
            return "Cannot upload event log, record list is empty";
        }
        for (LogEventRecord content : request.getRecords()) {
            if (!content.getEvents().isEmpty()) continue;
            return "Cannot upload event log, event list is empty";
        }
        return null;
    }

    private static void cleanupAllFiles() {
        try {
            List logs = FeatureUsageLogger.INSTANCE.getLogFiles();
            if (!logs.isEmpty()) {
                EventLogStatisticsService.cleanupFiles(logs);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private static void cleanupFiles(@NotNull List<File> toRemove2) {
        for (File file2 : toRemove2) {
            if (!file2.delete()) {
                LOG.warn("Failed deleting event log: " + file2.getName());
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Removed sent log: " + file2.getName());
        }
    }

    @Override
    public Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener2) {
        return null;
    }

    private static class EventLogCounterResultDecorator
    implements EventLogResultDecorator {
        private int myFailed = 0;
        private int mySucceed = 0;

        private EventLogCounterResultDecorator() {
        }

        @Override
        public void succeed(@NotNull LogEventRecordRequest request) {
            ++this.mySucceed;
        }

        @Override
        public void failed(@Nullable LogEventRecordRequest request) {
            ++this.myFailed;
        }

        @Override
        @NotNull
        public StatisticsResult toResult() {
            int total = this.mySucceed + this.myFailed;
            if (total == 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (this.myFailed > 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + this.mySucceed + " out of " + total + " files.");
            }
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + this.mySucceed + " files.");
        }
    }
}

