/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.ShortcutDataProvider;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\nJ\u0016\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000bJ\u0016\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0001H\u0002J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0000J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010!\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010$\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\u0005J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010&J\u0006\u0010'\u001a\u00020\u0000J\u0013\u0010(\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010*\u001a\u00020\u0005H\u0002J\b\u0010+\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "", "()V", "data", "", "", "addData", "key", "value", "", "", "", "addDataInternal", "addFeatureContext", "context", "Lcom/intellij/internal/statistic/service/fus/collectors/FUSUsageContext;", "addInputEvent", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Ljava/awt/event/KeyEvent;", "Ljava/awt/event/MouseEvent;", "addLanguage", "language", "Lcom/intellij/lang/Language;", "addOS", "addPlace", "place", "addPluginInfo", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "addProject", "project", "Lcom/intellij/openapi/project/Project;", "addVersion", "version", "Lcom/intellij/openapi/util/Version;", "addVersionByString", "build", "", "copy", "equals", "other", "getOS", "hashCode", "isCommonPlace", "merge", "next", "prefix", "intellij.platform.ide.impl"})
public final class FeatureUsageData {
    private Map<String, Object> data = ContainerUtil.newHashMap();

    @NotNull
    public final FeatureUsageData addFeatureContext(@Nullable FUSUsageContext context) {
        if (context != null) {
            this.data.putAll(context.getData());
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addProject(@Nullable Project project) {
        if (project != null) {
            Map<String, Object> map2 = this.data;
            String string = "project";
            String string2 = StatisticsUtilKt.getProjectId(project);
            map2.put(string, string2);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersionByString(@Nullable String version2) {
        if (version2 == null) {
            Map<String, Object> map2 = this.data;
            String string = "version";
            String string2 = "unknown";
            map2.put(string, string2);
        } else {
            this.addVersion(Version.parseVersion((String)version2));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersion(@Nullable Version version2) {
        Map<String, Object> map2 = this.data;
        String string = "version";
        String string2 = version2 != null ? "" + version2.major + '.' + version2.minor : "unknown.format";
        map2.put(string, string2);
        return this;
    }

    @NotNull
    public final FeatureUsageData addOS() {
        Map<String, Object> map2 = this.data;
        String string = "os";
        String string2 = this.getOS();
        map2.put(string, string2);
        return this;
    }

    private final String getOS() {
        if (SystemInfo.isWindows) {
            return "Windows";
        }
        if (SystemInfo.isMac) {
            return "Mac";
        }
        return SystemInfo.isLinux ? "Linux" : "Other";
    }

    @NotNull
    public final FeatureUsageData addPluginInfo(@NotNull PluginInfo info) {
        Map<String, Object> map2 = this.data;
        String string = "plugin_type";
        String string2 = info.getType().name();
        map2.put(string, string2);
        if (info.getType().isSafeToReport() && info.getId() != null && StringUtil.isNotEmpty((String)info.getId())) {
            map2 = this.data;
            string = "plugin";
            string2 = info.getId();
            map2.put(string, string2);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addLanguage(@NotNull Language language) {
        PluginType type = StatisticsUtilKt.getPluginType(language.getClass());
        if (type.isSafeToReport()) {
            Map<String, Object> map2 = this.data;
            String string = "lang";
            String string2 = language.getID();
            map2.put(string, string2);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull AnActionEvent event) {
        String inputEvent = ShortcutDataProvider.getActionEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            Map<String, Object> map2 = this.data;
            String string = "input_event";
            String string2 = inputEvent;
            map2.put(string, string2);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull KeyEvent event) {
        String inputEvent = ShortcutDataProvider.getKeyEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            Map<String, Object> map2 = this.data;
            String string = "input_event";
            String string2 = inputEvent;
            map2.put(string, string2);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull MouseEvent event) {
        String inputEvent = ShortcutDataProvider.getMouseEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            Map<String, Object> map2 = this.data;
            String string = "input_event";
            String string2 = inputEvent;
            map2.put(string, string2);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addPlace(@Nullable String place) {
        if (place == null) {
            return this;
        }
        String reported = "unknown";
        if (this.isCommonPlace(place)) {
            reported = place;
        } else if (ActionPlaces.isPopupPlace((String)place)) {
            reported = "popup";
        }
        Map<String, Object> map2 = this.data;
        String string = "place";
        String string2 = reported;
        map2.put(string, string2);
        return this;
    }

    private final boolean isCommonPlace(String place) {
        return ActionPlaces.isCommonPlace((String)place) || Intrinsics.areEqual((Object)"ToolwindowPopup", (Object)place);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, boolean value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, int value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, long value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, @NotNull String value) {
        return this.addDataInternal(key, value);
    }

    private final FeatureUsageData addDataInternal(String key, Object value) {
        Map<String, Object> map2 = this.data;
        Object object = value;
        map2.put(key, object);
        return this;
    }

    @NotNull
    public final Map<String, Object> build() {
        if (this.data.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.data;
    }

    @NotNull
    public final FeatureUsageData merge(@NotNull FeatureUsageData next, @NotNull String prefix) {
        Map<String, Object> map2 = next.build();
        Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            String key = entry2.getKey();
            entry2 = entry;
            Object value = entry2.getValue();
            String newKey = StringsKt.startsWith$default((String)key, (String)"data_", (boolean)false, (int)2, null) ? prefix + key : key;
            this.addDataInternal(newKey, value);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData copy() {
        FeatureUsageData result2 = new FeatureUsageData();
        Map<String, Object> map2 = this.data;
        Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            String key = entry2.getKey();
            entry2 = entry;
            Object value = entry2.getValue();
            result2.addDataInternal(key, value);
        }
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.FeatureUsageData");
        }
        FeatureUsageData cfr_ignored_0 = (FeatureUsageData)object2;
        return !(Intrinsics.areEqual(this.data, ((FeatureUsageData)other).data) ^ true);
    }

    public int hashCode() {
        return ((Object)this.data).hashCode();
    }
}

