/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;

public class FeatureUsageEventFileAppender
extends FileAppender {
    protected long maxFileAge = 1209600000L;
    protected long maxFileSize = 0xA00000L;
    private long nextRollover = 0L;
    protected long oldestExistingFile = -1L;
    private final Path myLogDirectory;
    private final Supplier<List<File>> myFilesProducer;

    public FeatureUsageEventFileAppender(@NotNull Path path, @NotNull List<File> files2) {
        this.myLogDirectory = path;
        this.myFilesProducer = () -> files2;
    }

    public FeatureUsageEventFileAppender(@NotNull Layout layout, @NotNull Path dir, @NotNull String filename) throws IOException {
        super(layout, filename);
        this.myLogDirectory = dir;
        this.myFilesProducer = () -> {
            Object[] files2 = dir.toFile().listFiles();
            return files2 == null || files2.length == 0 ? ContainerUtil.emptyList() : ContainerUtil.newArrayList((Object[])files2);
        };
        this.cleanUpOldFiles();
    }

    public static FeatureUsageEventFileAppender create(@NotNull Layout layout, @NotNull Path dir) throws IOException {
        File file2 = FeatureUsageEventFileAppender.nextFile(dir);
        return new FeatureUsageEventFileAppender(layout, dir, file2.getPath());
    }

    @NotNull
    public String getActiveLogName() {
        return StringUtil.isNotEmpty((String)this.fileName) ? PathUtil.getFileName((String)this.fileName) : "";
    }

    public void setMaxFileAge(long maxAge) {
        this.maxFileAge = maxAge;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    @NotNull
    protected CountingQuietWriter getQuietWriter() {
        return (CountingQuietWriter)this.qw;
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    public synchronized void setFile(String fileName2, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName2, append, bufferedIO, bufferSize);
        if (append && this.qw instanceof CountingQuietWriter) {
            File f = new File(fileName2);
            this.getQuietWriter().setCount(f.length());
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.fileName != null && this.qw != null && (size = this.getQuietWriter().getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
            this.cleanUpOldFiles();
        }
    }

    public void rollOver() {
        this.nextRollover = this.getQuietWriter().getCount() + this.maxFileSize;
        try {
            File file2 = FeatureUsageEventFileAppender.nextFile(this.myLogDirectory);
            this.setFile(file2.getPath(), false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    protected void cleanUpOldFiles() {
        long oldestAcceptable = System.currentTimeMillis() - this.maxFileAge;
        if (this.oldestExistingFile != -1L && oldestAcceptable < this.oldestExistingFile) {
            return;
        }
        this.cleanUpOldFiles(oldestAcceptable);
    }

    protected void cleanUpOldFiles(long oldestAcceptable) {
        List<File> logs = this.myFilesProducer.get();
        if (logs == null || logs.isEmpty()) {
            return;
        }
        String activeLog = this.getActiveLogName();
        long oldestFile = -1L;
        for (File file2 : logs) {
            if (StringUtil.equals((CharSequence)file2.getName(), (CharSequence)activeLog)) continue;
            long lastModified = file2.lastModified();
            if (lastModified < oldestAcceptable) {
                if (file2.delete()) continue;
                LogLog.error((String)("Failed deleting old file " + file2));
                continue;
            }
            if (lastModified >= oldestFile && oldestFile != -1L) continue;
            oldestFile = lastModified;
        }
        this.oldestExistingFile = oldestFile;
    }

    public void cleanUp() {
        List<File> logs = this.myFilesProducer.get();
        if (logs == null || logs.isEmpty()) {
            return;
        }
        for (File file2 : logs) {
            if (file2.delete()) continue;
            LogLog.error((String)("Failed deleting old file " + file2));
        }
    }

    @NotNull
    private static File nextFile(@NotNull Path dir) {
        File file2 = dir.resolve(UUID.randomUUID() + ".log").toFile();
        while (file2.exists()) {
            file2 = dir.resolve(UUID.randomUUID() + ".log").toFile();
        }
        return file2;
    }
}

