/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.FeatureUsageEventLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageEventWriter;
import com.intellij.internal.statistic.eventLog.FeatureUsageGroup;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.util.ConcurrencyUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0016J4\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0#2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageFileEventLogger;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventLogger;", "Lcom/intellij/openapi/Disposable;", "sessionId", "", "build", "bucket", "recorderVersion", "writer", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventWriter;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventWriter;)V", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "lastEventCreatedTime", "", "lastEventTime", "myLogExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getMyLogExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "cleanup", "", "dispose", "getLogFiles", "", "Ljava/io/File;", "log", "event", "createdTime", "group", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageGroup;", "action", "isState", "", "data", "", "", "logLastEvent", "intellij.platform.ide.impl"})
public class FeatureUsageFileEventLogger
implements FeatureUsageEventLogger,
Disposable {
    @NotNull
    private final ThreadPoolExecutor myLogExecutor;
    private LogEvent lastEvent;
    private long lastEventTime;
    private long lastEventCreatedTime;
    private final String sessionId;
    private final String build;
    private final String bucket;
    private final String recorderVersion;
    private final FeatureUsageEventWriter writer;

    @NotNull
    protected final ThreadPoolExecutor getMyLogExecutor() {
        return this.myLogExecutor;
    }

    public void log(@NotNull FeatureUsageGroup group, @NotNull String action, boolean isState) {
        this.log(group, action, Collections.emptyMap(), isState);
    }

    public void log(@NotNull FeatureUsageGroup group, @NotNull String action, @NotNull Map<String, ? extends Object> data, boolean isState) {
        long eventTime = System.currentTimeMillis();
        this.myLogExecutor.execute(new Runnable(this, eventTime, group, action, isState, data){
            final /* synthetic */ FeatureUsageFileEventLogger this$0;
            final /* synthetic */ long $eventTime;
            final /* synthetic */ FeatureUsageGroup $group;
            final /* synthetic */ String $action;
            final /* synthetic */ boolean $isState;
            final /* synthetic */ Map $data;

            public final void run() {
                long creationTime = System.currentTimeMillis();
                LogEvent event = LogEventsKt.newLogEvent(FeatureUsageFileEventLogger.access$getSessionId$p(this.this$0), FeatureUsageFileEventLogger.access$getBuild$p(this.this$0), FeatureUsageFileEventLogger.access$getBucket$p(this.this$0), this.$eventTime, this.$group.getId(), String.valueOf(this.$group.getVersion()), FeatureUsageFileEventLogger.access$getRecorderVersion$p(this.this$0), this.$action, this.$isState);
                Map map2 = this.$data;
                for (Map.Entry<K, V> datum : map2.entrySet()) {
                    event.getEvent().addData((String)datum.getKey(), datum.getValue());
                }
                FeatureUsageFileEventLogger.access$log(this.this$0, FeatureUsageFileEventLogger.access$getWriter$p(this.this$0), event, creationTime);
            }
            {
                this.this$0 = featureUsageFileEventLogger;
                this.$eventTime = l;
                this.$group = featureUsageGroup;
                this.$action = string;
                this.$isState = bl;
                this.$data = map2;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void log(FeatureUsageEventWriter writer, LogEvent event, long createdTime) {
        if (this.lastEvent != null && event.getTime() - this.lastEventTime <= (long)10000) {
            LogEvent logEvent = this.lastEvent;
            if (logEvent == null) {
                Intrinsics.throwNpe();
            }
            if (logEvent.shouldMerge(event)) {
                this.lastEventTime = event.getTime();
                LogEvent logEvent2 = this.lastEvent;
                if (logEvent2 == null) {
                    Intrinsics.throwNpe();
                }
                logEvent2.getEvent().increment();
                return;
            }
        }
        this.logLastEvent(writer);
        this.lastEvent = event;
        this.lastEventTime = event.getTime();
        this.lastEventCreatedTime = createdTime;
    }

    private final void logLastEvent(FeatureUsageEventWriter writer) {
        LogEvent logEvent = this.lastEvent;
        if (logEvent != null) {
            LogEvent logEvent2;
            LogEvent it = logEvent2 = logEvent;
            boolean bl = false;
            if (it.getEvent().isEventGroup()) {
                it.getEvent().addData("last", this.lastEventTime);
            }
            it.getEvent().addData("created", this.lastEventCreatedTime);
            writer.log(LogEventSerializer.INSTANCE.toString(it));
        }
        this.lastEvent = null;
    }

    @NotNull
    public List<File> getLogFiles() {
        return this.writer.getFiles();
    }

    public void cleanup() {
        this.writer.cleanup();
    }

    public void dispose() {
        this.dispose(this.writer);
    }

    private final void dispose(FeatureUsageEventWriter writer) {
        this.myLogExecutor.execute(new Runnable(this, writer){
            final /* synthetic */ FeatureUsageFileEventLogger this$0;
            final /* synthetic */ FeatureUsageEventWriter $writer;

            public final void run() {
                FeatureUsageFileEventLogger.access$logLastEvent(this.this$0, this.$writer);
            }
            {
                this.this$0 = featureUsageFileEventLogger;
                this.$writer = featureUsageEventWriter;
            }
        });
        this.myLogExecutor.shutdown();
    }

    public FeatureUsageFileEventLogger(@NotNull String sessionId, @NotNull String build2, @NotNull String bucket, @NotNull String recorderVersion, @NotNull FeatureUsageEventWriter writer) {
        this.sessionId = sessionId;
        this.build = build2;
        this.bucket = bucket;
        this.recorderVersion = recorderVersion;
        this.writer = writer;
        this.myLogExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)this.getClass().getSimpleName());
    }

    public static final /* synthetic */ String access$getSessionId$p(FeatureUsageFileEventLogger $this) {
        return $this.sessionId;
    }

    public static final /* synthetic */ String access$getBuild$p(FeatureUsageFileEventLogger $this) {
        return $this.build;
    }

    public static final /* synthetic */ String access$getBucket$p(FeatureUsageFileEventLogger $this) {
        return $this.bucket;
    }

    public static final /* synthetic */ String access$getRecorderVersion$p(FeatureUsageFileEventLogger $this) {
        return $this.recorderVersion;
    }

    public static final /* synthetic */ void access$log(FeatureUsageFileEventLogger $this, FeatureUsageEventWriter writer, LogEvent event, long createdTime) {
        $this.log(writer, event, createdTime);
    }

    public static final /* synthetic */ FeatureUsageEventWriter access$getWriter$p(FeatureUsageFileEventLogger $this) {
        return $this.writer;
    }

    public static final /* synthetic */ void access$logLastEvent(FeatureUsageFileEventLogger $this, FeatureUsageEventWriter writer) {
        $this.logLastEvent(writer);
    }
}

