/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEvents;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J$\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J,\u0010\u0018\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageUiEventsImpl;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageUiEvents;", "()V", "APPLY_CONFIGURABLE_DATA", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "CLOSE_CANCEL_DIALOG_DATA", "CLOSE_CUSTOM_DIALOG_DATA", "CLOSE_OK_DIALOG_DATA", "RESET_CONFIGURABLE_DATA", "SELECT_CONFIGURABLE_DATA", "SHOW_DIALOG_DATA", "getDataForCloseDialog", "exitCode", "", "logApplyConfigurable", "", "name", "", "context", "Ljava/lang/Class;", "logCloseDialog", "logResetConfigurable", "logSelectConfigurable", "logShowDialog", "toReport", "defaultValue", "data", "intellij.platform.ide.impl"})
public final class FeatureUsageUiEventsImpl
implements FeatureUsageUiEvents {
    private final FeatureUsageData SELECT_CONFIGURABLE_DATA = new FeatureUsageData().addData("type", "select");
    private final FeatureUsageData APPLY_CONFIGURABLE_DATA = new FeatureUsageData().addData("type", "apply");
    private final FeatureUsageData RESET_CONFIGURABLE_DATA = new FeatureUsageData().addData("type", "reset");
    private final FeatureUsageData SHOW_DIALOG_DATA = new FeatureUsageData().addData("type", "show");
    private final FeatureUsageData CLOSE_OK_DIALOG_DATA = new FeatureUsageData().addData("type", "close").addData("code", 0);
    private final FeatureUsageData CLOSE_CANCEL_DIALOG_DATA = new FeatureUsageData().addData("type", "close").addData("code", 1);
    private final FeatureUsageData CLOSE_CUSTOM_DIALOG_DATA = new FeatureUsageData().addData("type", "close").addData("code", 2);

    public void logSelectConfigurable(@NotNull String name, @NotNull Class<?> context) {
    }

    public void logApplyConfigurable(@NotNull String name, @NotNull Class<?> context) {
    }

    public void logResetConfigurable(@NotNull String name, @NotNull Class<?> context) {
    }

    public void logShowDialog(@NotNull String name, @NotNull Class<?> context) {
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            FeatureUsageData data = this.SHOW_DIALOG_DATA.copy();
            String report = this.toReport(context, name, "third.party", data);
            FUCounterUsageLogger.getInstance().logEvent("ui.dialogs", report, data);
        }
    }

    public void logCloseDialog(@NotNull String name, int exitCode, @NotNull Class<?> context) {
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            FeatureUsageData data = this.getDataForCloseDialog(exitCode).copy();
            String report = this.toReport(context, name, "third.party", data);
            FUCounterUsageLogger.getInstance().logEvent("ui.dialogs", report, data);
        }
    }

    private final FeatureUsageData getDataForCloseDialog(int exitCode) {
        if (exitCode == 0) {
            return this.CLOSE_OK_DIALOG_DATA;
        }
        if (exitCode == 1) {
            return this.CLOSE_CANCEL_DIALOG_DATA;
        }
        return this.CLOSE_CUSTOM_DIALOG_DATA;
    }

    private final String toReport(Class<?> context, String name, String defaultValue, FeatureUsageData data) {
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(context);
        data.addPluginInfo(info);
        return info.isDevelopedByJetBrains() ? name : defaultValue;
    }
}

