/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.util.containers.hash.HashMap;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "()V", "createAction", "Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "obj", "Lcom/google/gson/JsonObject;", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "intellij.platform.ide.impl"})
public final class LogEventJsonDeserializer
implements JsonDeserializer<LogEvent> {
    @NotNull
    public LogEvent deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String recorderVersion = obj.get("recorder_version").getAsString();
        String session2 = obj.get("session").getAsString();
        String build2 = obj.get("build").getAsString();
        String bucket = obj.get("bucket").getAsString();
        long time = obj.get("time").getAsLong();
        JsonObject group = obj.get("group").getAsJsonObject();
        String groupId = group.get("id").getAsString();
        String groupVersion = group.get("version").getAsString();
        JsonObject actionObj = obj.get("event").getAsJsonObject();
        LogEventAction action = this.createAction(actionObj);
        if (actionObj.has("data")) {
            JsonObject dataObj = actionObj.getAsJsonObject("data");
            Map map2 = (Map)context.deserialize((JsonElement)dataObj, new TypeToken<HashMap<String, Object>>(){}.getType());
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                String key = (String)entry2.getKey();
                entry2 = entry;
                Object value = entry2.getValue();
                if (value instanceof Double && ((Number)value).doubleValue() % 1.0 == 0.0) {
                    long longValue = Math.round(((Number)value).doubleValue());
                    action.addData(key, longValue);
                    continue;
                }
                action.addData(key, value);
            }
        }
        return LogEventsKt.newLogEvent(session2, build2, bucket, time, groupId, groupVersion, recorderVersion, action);
    }

    @NotNull
    public final LogEventAction createAction(@NotNull JsonObject obj) {
        JsonPrimitive count;
        boolean isState;
        String id = obj.get("id").getAsString();
        boolean bl = isState = obj.has("state") && obj.get("state").getAsBoolean();
        if (obj.has("count") && (count = obj.get("count").getAsJsonPrimitive()).isNumber()) {
            return new LogEventAction(id, isState, count.getAsInt());
        }
        return new LogEventAction(id, isState, 0, 4, null);
    }
}

