/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordSizeEstimator;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "", "product", "", "device", "records", "", "Lcom/intellij/internal/statistic/eventLog/LogEventRecord;", "internal", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Z)V", "getDevice", "()Ljava/lang/String;", "getInternal", "()Z", "getProduct", "recorder", "getRecorder", "getRecords", "()Ljava/util/List;", "equals", "other", "hashCode", "", "Companion", "intellij.platform.ide.impl"})
public final class LogEventRecordRequest {
    @NotNull
    private final String recorder = "FUS";
    @NotNull
    private final String product;
    @NotNull
    private final String device;
    @NotNull
    private final List<LogEventRecord> records;
    private final boolean internal;
    private static final int RECORD_SIZE = 1000000;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEventRecordRequest");
        }
        LogEventRecordRequest cfr_ignored_0 = (LogEventRecordRequest)object2;
        if (Intrinsics.areEqual((Object)this.product, (Object)((LogEventRecordRequest)other).product) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.device, (Object)((LogEventRecordRequest)other).device) ^ true) {
            return false;
        }
        if (this.internal != ((LogEventRecordRequest)other).internal) {
            return false;
        }
        return !(Intrinsics.areEqual(this.records, ((LogEventRecordRequest)other).records) ^ true);
    }

    public int hashCode() {
        int result2 = this.product.hashCode();
        result2 = 31 * result2 + this.device.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.internal);
        result2 = 31 * result2 + ((Object)this.records).hashCode();
        return result2;
    }

    @NotNull
    public final String getProduct() {
        return this.product;
    }

    @NotNull
    public final String getDevice() {
        return this.device;
    }

    @NotNull
    public final List<LogEventRecord> getRecords() {
        return this.records;
    }

    public final boolean getInternal() {
        return this.internal;
    }

    public LogEventRecordRequest(@NotNull String product, @NotNull String device, @NotNull List<LogEventRecord> records, boolean internal) {
        this.product = product;
        this.device = device;
        this.records = records;
        this.internal = internal;
        this.recorder = "FUS";
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(LogEventRecordRequest.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ8\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJB\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RECORD_SIZE", "", "create", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "file", "Ljava/io/File;", "filter", "Lcom/intellij/internal/statistic/eventLog/LogEventFilter;", "internal", "", "product", "", "user", "maxRecordSize", "fillNextBatch", "reader", "Ljava/io/BufferedReader;", "firstLine", "events", "", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "estimator", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordSizeEstimator;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        public final LogEventRecordRequest create(@NotNull File file2, @NotNull LogEventFilter filter, boolean internal) {
            try {
                return this.create(file2, ApplicationInfo.getInstance().getBuild().getProductCode(), EventLogConfiguration.INSTANCE.getDeviceId(), 1000000, filter, internal);
            }
            catch (Exception e) {
                LOG.warn("Failed reading event log file", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final LogEventRecordRequest create(@NotNull File file2, @NotNull String product, @NotNull String user, int maxRecordSize, @NotNull LogEventFilter filter, boolean internal) {
            try {
                ArrayList<LogEventRecord> records = new ArrayList<LogEventRecord>();
                Closeable closeable = new BufferedReader(new FileReader(file2.getPath()));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    LogEventRecordSizeEstimator sizeEstimator = new LogEventRecordSizeEstimator(product, user);
                    ArrayList events = new ArrayList();
                    String line = Companion.fillNextBatch(reader, reader.readLine(), events, sizeEstimator, maxRecordSize, filter);
                    while (!events.isEmpty()) {
                        records.add(new LogEventRecord(events));
                        events = new ArrayList();
                        line = Companion.fillNextBatch(reader, line, events, sizeEstimator, maxRecordSize, filter);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return new LogEventRecordRequest(product, user, (List<LogEventRecord>)records, internal);
            }
            catch (JsonSyntaxException e) {
                LOG.warn((Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            return null;
        }

        private final String fillNextBatch(BufferedReader reader, String firstLine, List<LogEvent> events, LogEventRecordSizeEstimator estimator, int maxRecordSize, LogEventFilter filter) {
            int recordSize = 0;
            String line = firstLine;
            while (line != null && recordSize + estimator.estimate(line) < maxRecordSize) {
                LogEvent event = LogEventSerializer.INSTANCE.fromString(line);
                if (event != null && filter.accepts(event)) {
                    recordSize += estimator.estimate(line);
                    events.add(event);
                }
                line = reader.readLine();
            }
            return line;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

