/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.collectors.fus.os.OsVersionUsageCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FeatureUsageGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageStateEventTracker;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.lang.JavaVersion;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/SystemStateMonitor;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageStateEventTracker;", "()V", "INITIAL_DELAY", "", "JAVA_GROUP", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageGroup;", "OS_GROUP", "PERIOD_DELAY", "getJavaVendor", "", "getOSName", "getOSVersion", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "initialize", "", "logSystemEvent", "intellij.platform.ide.impl"})
public final class SystemStateMonitor
implements FeatureUsageStateEventTracker {
    private final FeatureUsageGroup OS_GROUP = new FeatureUsageGroup("system.os", 1);
    private final FeatureUsageGroup JAVA_GROUP = new FeatureUsageGroup("system.java", 1);
    private final int INITIAL_DELAY = 0;
    private final int PERIOD_DELAY = 1440;

    public void initialize() {
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ SystemStateMonitor this$0;

            public final void run() {
                SystemStateMonitor.access$logSystemEvent(this.this$0);
            }
            {
                this.this$0 = systemStateMonitor;
            }
        }, this.INITIAL_DELAY, this.PERIOD_DELAY, TimeUnit.MINUTES);
    }

    private final void logSystemEvent() {
        FUStateUsagesLogger.logStateEvent(this.OS_GROUP, this.getOSName(), this.getOSVersion());
        FeatureUsageData data = new FeatureUsageData().addVersion(new Version(1, JavaVersion.current().feature, 0));
        FUStateUsagesLogger.logStateEvent(this.JAVA_GROUP, this.getJavaVendor(), data);
    }

    private final FeatureUsageData getOSVersion() {
        FeatureUsageData osData = new FeatureUsageData();
        if (SystemInfo.isLinux) {
            OsVersionUsageCollector.LinuxRelease linuxRelease = OsVersionUsageCollector.getLinuxRelease();
            osData.addData("release", linuxRelease.getRelease());
            osData.addVersionByString(linuxRelease.getVersion());
        } else {
            osData.addVersion(OsVersionUsageCollector.parse(SystemInfo.OS_VERSION));
        }
        return osData;
    }

    private final String getOSName() {
        return SystemInfo.isLinux ? "Linux" : (SystemInfo.isMac ? "Mac" : (SystemInfo.isWindows ? "Windows" : (SystemInfo.isFreeBSD ? "FreeBDS" : (SystemInfo.isSolaris ? "Solaris" : "Other"))));
    }

    private final String getJavaVendor() {
        return SystemInfo.isJetBrainsJvm ? "JetBrains" : (SystemInfo.isAppleJvm ? "Apple" : (SystemInfo.isOracleJvm ? "Oracle" : (SystemInfo.isSunJvm ? "Sun" : (SystemInfo.isIbmJvm ? "IBM" : (SystemInfo.isAzulJvm ? "Azul" : "Other")))));
    }

    public static final /* synthetic */ void access$logSystemEvent(SystemStateMonitor $this) {
        $this.logSystemEvent();
    }
}

