/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="FusApprovedGroupsCacheConfigurable", storages={@Storage(value="$CACHE_FILE$")})
public class ApprovedGroupsCacheConfigurable
implements PersistentStateComponent<State> {
    private static final int CACHE_FORMAT = 1;
    private State myState = new State();

    public static ApprovedGroupsCacheConfigurable getInstance() {
        return (ApprovedGroupsCacheConfigurable)ServiceManager.getService(ApprovedGroupsCacheConfigurable.class);
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    @Nullable
    public FUSWhitelist getCachedGroups(@NotNull Date date, long cacheActualDuration, @Nullable BuildNumber currentBuild) {
        BuildNumber cachedBuild;
        State state = this.getState();
        if (state.getCacheFormatVersion() < 1) {
            return null;
        }
        Date lastUpdate = state.getLastUpdate();
        if (date.getTime() - lastUpdate.getTime() > cacheActualDuration) {
            return null;
        }
        if (currentBuild != null && (cachedBuild = BuildNumber.fromStringOrNull((String)state.getBuild())) != null && currentBuild.compareTo(cachedBuild) != 0) {
            return null;
        }
        return state.getWhitelist();
    }

    public FUSWhitelist getCachedGroups(Date date, long cacheActualDuration) {
        return this.getCachedGroups(date, cacheActualDuration, null);
    }

    public FUSWhitelist cacheGroups(@NotNull Date date, @NotNull FUSWhitelist whitelist, @NotNull BuildNumber build2) {
        State state = this.getState();
        state.setCacheFormatVersion(1);
        state.setWhitelist(whitelist);
        state.setLastUpdate(date);
        state.setBuild(build2.asString());
        return whitelist;
    }

    public static class State {
        private FUSWhitelist myWhitelist = FUSWhitelist.empty();
        private Date myLastUpdate = new Date(0L);
        private String myBuild = "";
        private int myCacheFormatVersion = 0;

        @Tag(value="whitelist")
        public FUSWhitelist getWhitelist() {
            return this.myWhitelist;
        }

        public void setWhitelist(FUSWhitelist whitelist) {
            this.myWhitelist = whitelist;
        }

        @Attribute(value="last_update")
        public Date getLastUpdate() {
            return this.myLastUpdate;
        }

        public void setLastUpdate(Date lastUpdate) {
            this.myLastUpdate = lastUpdate;
        }

        @Attribute(value="build")
        public String getBuild() {
            return this.myBuild;
        }

        public void setBuild(String build2) {
            this.myBuild = build2;
        }

        @Attribute(value="cache_version")
        public int getCacheFormatVersion() {
            return this.myCacheFormatVersion;
        }

        public void setCacheFormatVersion(int cacheFormatVersion) {
            this.myCacheFormatVersion = cacheFormatVersion;
        }
    }
}

