/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.android.tools.analytics.AnalyticsPublisher;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.AnalyticsSettingsData;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.internal.statistic.configurable.SendPeriod;
import com.intellij.internal.statistic.persistence.BasicSentUsagesPersistenceComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="UsagesStatistic", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class UsageStatisticsPersistenceComponent
extends BasicSentUsagesPersistenceComponent
implements PersistentStateComponent<Element> {
    public static final String USAGE_STATISTICS_XML = "usage.statistics.xml";
    private boolean isShowNotification = true;
    @NotNull
    private SendPeriod myPeriod = SendPeriod.DAILY;
    private static final String LAST_TIME_ATTR = "time";
    private static final String IS_ALLOWED_ATTR = "allowed";
    private static final String SHOW_NOTIFICATION_ATTR = "show-notification";
    private ILogger androidLogger;

    public static UsageStatisticsPersistenceComponent getInstance() {
        return (UsageStatisticsPersistenceComponent)ApplicationManager.getApplication().getComponent(UsageStatisticsPersistenceComponent.class);
    }

    public UsageStatisticsPersistenceComponent() {
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.isShowNotification = false;
        }
    }

    public void loadState(@NotNull Element element) {
        String isShowNotificationValue;
        try {
            this.setSentTime(Long.parseLong(element.getAttributeValue(LAST_TIME_ATTR, "0")));
        }
        catch (NumberFormatException e) {
            this.setSentTime(0L);
        }
        String isAllowedValue = element.getAttributeValue(IS_ALLOWED_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)isAllowedValue) && Boolean.parseBoolean(isAllowedValue)) {
            this.setAllowed(true);
        }
        this.setShowNotification(StringUtil.isEmptyOrSpaces((String)(isShowNotificationValue = element.getAttributeValue(SHOW_NOTIFICATION_ATTR))) || Boolean.parseBoolean(isShowNotificationValue));
    }

    public Element getState() {
        Element element = new Element("state");
        long lastTimeSent = this.getLastTimeSent();
        if (lastTimeSent > 0L) {
            element.setAttribute(LAST_TIME_ATTR, String.valueOf(lastTimeSent));
        }
        if (!this.isShowNotification()) {
            element.setAttribute(SHOW_NOTIFICATION_ATTR, "false");
        }
        return element;
    }

    @NotNull
    public SendPeriod getPeriod() {
        return this.myPeriod;
    }

    public void setPeriod(@NotNull SendPeriod period) {
        this.myPeriod = period;
    }

    public void setAllowed(boolean allowed) {
        ConsentOptions.getInstance().setSendingUsageStatsAllowed(allowed);
    }

    public void updateAndroidStudioMetrics() {
        this.updateAndroidStudioMetrics(ConsentOptions.getInstance().isSendingUsageStatsAllowed() == ConsentOptions.Permission.YES);
    }

    private void updateAndroidStudioMetrics(boolean allowed) {
        boolean updated = false;
        try {
            if (allowed == AnalyticsSettings.getOptedIn()) {
                updated = false;
            } else {
                AnalyticsSettings.setOptedIn((boolean)allowed);
                AnalyticsSettings.saveSettings();
                updated = true;
            }
        }
        catch (IOException e) {
            this.getAndroidLogger().error((Throwable)e, "Unable to update analytics settings", new Object[0]);
        }
        if (updated) {
            this.initializeAndroidStudioUsageTrackerAndPublisher();
        }
    }

    public void initializeAndroidStudioUsageTrackerAndPublisher() {
        ILogger logger = this.getAndroidLogger();
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        AnalyticsSettings.initialize((ILogger)logger, (ScheduledExecutorService)scheduler);
        try {
            boolean ijOptedIn;
            boolean bl = ijOptedIn = ConsentOptions.getInstance().isSendingUsageStatsAllowed() == ConsentOptions.Permission.YES;
            if (AnalyticsSettings.getOptedIn() != ijOptedIn) {
                AnalyticsSettings.setOptedIn((boolean)ijOptedIn);
                AnalyticsSettings.saveSettings();
            }
            UsageTracker.initialize((ScheduledExecutorService)scheduler);
        }
        catch (Exception e) {
            logger.warning("Unable to initialize analytics tracker: " + e.getMessage(), new Object[0]);
            return;
        }
        UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
        UsageTracker.setMaxJournalSize((int)1000);
        ApplicationInfo application = ApplicationInfo.getInstance();
        AnalyticsPublisher.updatePublisher((ILogger)logger, (ScheduledExecutorService)scheduler, (String)application.getStrictVersion());
    }

    @Override
    public boolean isAllowed() {
        if (!AnalyticsSettings.getInitialized()) {
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isUnitTestMode()) {
                AnalyticsSettingsData analyticsSettings = new AnalyticsSettingsData();
                analyticsSettings.setOptedIn(false);
                AnalyticsSettings.setInstanceForTest((AnalyticsSettingsData)analyticsSettings);
            } else {
                AnalyticsSettings.initialize((ILogger)this.getAndroidLogger());
            }
        }
        return AnalyticsSettings.getOptedIn();
    }

    public void setShowNotification(boolean showNotification2) {
        this.isShowNotification = showNotification2;
    }

    @Override
    public boolean isShowNotification() {
        return this.isShowNotification;
    }

    private ILogger getAndroidLogger() {
        if (this.androidLogger == null) {
            final Logger intelliJLogger = Logger.getInstance((String)"#com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent");
            this.androidLogger = new ILogger(){

                public void error(Throwable t, String msgFormat, Object ... args) {
                    intelliJLogger.error(String.format(msgFormat, args), t);
                }

                public void warning(String msgFormat, Object ... args) {
                    intelliJLogger.warn(String.format(msgFormat, args));
                }

                public void info(String msgFormat, Object ... args) {
                    intelliJLogger.info(String.format(msgFormat, args));
                }

                public void verbose(String msgFormat, Object ... args) {
                    this.info(msgFormat, args);
                }
            };
        }
        return this.androidLogger;
    }
}

