/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUSWhitelist {
    private Map<String, List<VersionRange>> myGroups;

    public FUSWhitelist() {
    }

    private FUSWhitelist(@NotNull Map<String, List<VersionRange>> groups) {
        this.myGroups = groups;
    }

    @NotNull
    public static FUSWhitelist create(@NotNull Map<String, List<VersionRange>> groupsToVersion) {
        return new FUSWhitelist(groupsToVersion);
    }

    @NotNull
    public static FUSWhitelist empty() {
        return new FUSWhitelist(Collections.emptyMap());
    }

    @XMap(propertyElementName="groups", keyAttributeName="id", entryTagName="group")
    public Map<String, List<VersionRange>> getGroups() {
        return this.myGroups;
    }

    public void setGroups(Map<String, List<VersionRange>> groups) {
        this.myGroups = groups;
    }

    public boolean accepts(@NotNull String groupId, @Nullable String version2) {
        int parsed = FUSWhitelist.tryToParse(version2, -1);
        if (parsed < 0) {
            return false;
        }
        return this.accepts(groupId, parsed);
    }

    public boolean accepts(@NotNull String groupId, int version2) {
        if (!this.myGroups.containsKey(groupId)) {
            return false;
        }
        List<VersionRange> ranges = this.myGroups.get(groupId);
        return ranges.isEmpty() || ContainerUtil.find(ranges, range2 -> range2.contains(version2)) != null;
    }

    public int getSize() {
        return this.myGroups.size();
    }

    public boolean isEmpty() {
        return this.myGroups.isEmpty();
    }

    private static int tryToParse(@Nullable String value, int defaultValue) {
        try {
            if (value != null) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FUSWhitelist whitelist = (FUSWhitelist)o;
        return Objects.equals(this.myGroups, whitelist.myGroups);
    }

    public int hashCode() {
        return Objects.hash(this.myGroups);
    }

    @Tag(value="version")
    public static class VersionRange {
        private int myFrom;
        private int myTo;

        @NotNull
        public static VersionRange create(@Nullable String from, @Nullable String to) {
            VersionRange range2 = new VersionRange();
            range2.setFrom(from == null ? 0 : FUSWhitelist.tryToParse(from, Integer.MAX_VALUE));
            range2.setTo(to == null ? Integer.MAX_VALUE : FUSWhitelist.tryToParse(to, 0));
            return range2;
        }

        @Attribute(value="from")
        public int getFrom() {
            return this.myFrom;
        }

        public void setFrom(int from) {
            this.myFrom = from;
        }

        @Attribute(value="to")
        public int getTo() {
            return this.myTo;
        }

        public void setTo(int to) {
            this.myTo = to;
        }

        public boolean contains(int current) {
            return current >= this.myFrom && current < this.myTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionRange range2 = (VersionRange)o;
            return this.myFrom == range2.myFrom && this.myTo == range2.myTo;
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }
    }
}

