/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsWhiteListGroupsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.whiteList.FUStatisticsWhiteListGroupsService");

    @Nullable
    public static FUSWhitelist getApprovedGroups(@NotNull String serviceUrl, @NotNull BuildNumber current) {
        String content = null;
        try {
            content = HttpRequests.request((String)serviceUrl).productNameAsUserAgent().readString(null);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return content != null ? FUStatisticsWhiteListGroupsService.parseApprovedGroups(content, current) : null;
    }

    @VisibleForTesting
    @NotNull
    public static FUSWhitelist parseApprovedGroups(String content, @NotNull BuildNumber build2) {
        WLGroups groups = null;
        try {
            groups = (WLGroups)new GsonBuilder().create().fromJson(content, WLGroups.class);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        if (groups == null) {
            return FUSWhitelist.empty();
        }
        Map<String, List<FUSWhitelist.VersionRange>> result2 = groups.groups.stream().filter(group -> group.accepts(build2)).collect(Collectors.toMap(group -> group.id, group -> FUStatisticsWhiteListGroupsService.toVersionRanges(group.versions)));
        return FUSWhitelist.create(result2);
    }

    @NotNull
    private static List<FUSWhitelist.VersionRange> toVersionRanges(@Nullable ArrayList<WLVersion> versions) {
        return versions == null || versions.isEmpty() ? ContainerUtil.emptyList() : ContainerUtil.map(versions, version2 -> FUSWhitelist.VersionRange.create(version2.from, version2.to));
    }

    private static class WLBuild {
        public final String from;
        public final String to;

        private WLBuild(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public boolean contains(BuildNumber build2) {
            return !(!StringUtil.isEmpty((String)this.to) && BuildNumber.fromString((String)this.to).compareTo(build2) <= 0 || !StringUtil.isEmpty((String)this.from) && BuildNumber.fromString((String)this.from).compareTo(build2) > 0);
        }
    }

    private static class WLVersion {
        public final String from;
        public final String to;

        private WLVersion(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    private static class WLGroup {
        @Nullable
        public final String id;
        @Nullable
        public final ArrayList<WLBuild> builds = new ArrayList();
        @Nullable
        public final ArrayList<WLVersion> versions = new ArrayList();

        WLGroup(@Nullable String id) {
            this.id = id;
        }

        public boolean accepts(BuildNumber current) {
            if (!this.isValid()) {
                return false;
            }
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            return !hasBuilds || this.builds.stream().anyMatch(build2 -> build2.contains(current));
        }

        private boolean isValid() {
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            boolean hasVersions = this.versions != null && !this.versions.isEmpty();
            return StringUtil.isNotEmpty((String)this.id) && (hasBuilds || hasVersions);
        }
    }

    private static class WLGroups {
        @NotNull
        public final ArrayList<WLGroup> groups = new ArrayList();

        private WLGroups() {
        }
    }
}

