/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FeatureUsageGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUCounterUsageLogger {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger");
    private static final int LOG_REGISTERED_DELAY_MIN = 1440;
    private static final int LOG_REGISTERED_INITIAL_DELAY_MIN = 5;
    private static final String REGISTERED = "registered";
    private static final String[] GENERAL_GROUPS = new String[]{"lifecycle", "performance", "actions", "ui.dialogs", "toolwindow", "intentions", "toolbar", "run.configuration.exec", "file.types.usage", "productivity", "live.templates", "completion.postfix"};
    private static final FUCounterUsageLogger INSTANCE = new FUCounterUsageLogger();
    private final Map<String, FeatureUsageGroup> myGroups = new HashMap<String, FeatureUsageGroup>();

    @NotNull
    public static FUCounterUsageLogger getInstance() {
        return INSTANCE;
    }

    public FUCounterUsageLogger() {
        int version2 = 11;
        for (String group : GENERAL_GROUPS) {
            this.register(new FeatureUsageGroup(group, version2));
        }
        for (CounterUsageCollectorEP ep : CounterUsageCollectorEP.EP_NAME.getExtensionList()) {
            String id = ep.getGroupId();
            if (!StringUtil.isNotEmpty((String)id)) continue;
            this.register(new FeatureUsageGroup(id, ep.version));
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.logRegisteredGroups(), 5L, 1440L, TimeUnit.MINUTES);
    }

    public void register(@NotNull FeatureUsageGroup group) {
        this.myGroups.put(group.getId(), group);
    }

    public void logRegisteredGroups() {
        for (FeatureUsageGroup group : this.myGroups.values()) {
            FeatureUsageLogger.INSTANCE.log(group, REGISTERED);
        }
    }

    public void logEvent(@NotNull Project project, @NotNull String groupId, @NotNull String event) {
        FeatureUsageGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            Map<String, Object> data = new FeatureUsageData().addProject(project).build();
            FeatureUsageLogger.INSTANCE.log(group, event, data);
        }
    }

    public void logEvent(@NotNull Project project, @NotNull String groupId, @NotNull String event, @NotNull FeatureUsageData data) {
        FeatureUsageGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, event, data.addProject(project).build());
        }
    }

    public void logEvent(@NotNull String groupId, @NotNull String event) {
        FeatureUsageGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, event);
        }
    }

    public void logEvent(@NotNull String groupId, @NotNull String event, @NotNull FeatureUsageData data) {
        FeatureUsageGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, event, data.build());
        }
    }

    @Nullable
    private FeatureUsageGroup findRegisteredGroupById(@NotNull String groupId) {
        if (!this.myGroups.containsKey(groupId)) {
            LOG.warn("Cannot record event because group '" + groupId + "' is not registered.");
            return null;
        }
        return this.myGroups.get(groupId);
    }
}

