/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FeatureUsageGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStateUsagesLogger
implements UsagesCollectorConsumer {
    private static final String INVOKED = "invoked";

    public static FUStateUsagesLogger create() {
        return new FUStateUsagesLogger();
    }

    public void logProjectStates(@NotNull Project project) {
        this.logProjectStates(project, EventLogExternalSettingsService.getInstance().getApprovedGroups(), false);
    }

    public void logApplicationStates() {
        this.logApplicationStates(EventLogExternalSettingsService.getInstance().getApprovedGroups(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logProjectStates(@NotNull Project project, @NotNull FUSWhitelist whitelist, boolean recordAll) {
        if (!whitelist.isEmpty() || ApplicationManagerEx.getApplicationEx().isInternal()) {
            Object object = StatisticsUploadAssistant.LOCK;
            synchronized (object) {
                for (ProjectUsagesCollector usagesCollector : ProjectUsagesCollector.getExtensions(this)) {
                    if (!recordAll && !whitelist.accepts(usagesCollector.getGroupId(), usagesCollector.getVersion())) continue;
                    FeatureUsageGroup group = new FeatureUsageGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
                    FUStateUsagesLogger.logUsagesAsStateEvents(project, group, usagesCollector.getData(project), usagesCollector.getUsages(project));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logApplicationStates(@NotNull FUSWhitelist whitelist, boolean recordAll) {
        Object object = StatisticsUploadAssistant.LOCK;
        synchronized (object) {
            for (ApplicationUsagesCollector usagesCollector : ApplicationUsagesCollector.getExtensions(this)) {
                if (!recordAll && !whitelist.accepts(usagesCollector.getGroupId(), usagesCollector.getVersion())) continue;
                FeatureUsageGroup group = new FeatureUsageGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
                FUStateUsagesLogger.logUsagesAsStateEvents(null, group, usagesCollector.getData(), usagesCollector.getUsages());
            }
        }
    }

    private static void logUsagesAsStateEvents(@Nullable Project project, @NotNull FeatureUsageGroup group, @Nullable FeatureUsageData context, @NotNull Set<UsageDescriptor> usages) {
        FeatureUsageLogger logger = FeatureUsageLogger.INSTANCE;
        if (!(usages = usages.stream().filter(descriptor -> descriptor.getValue() > 0).collect(Collectors.toSet())).isEmpty()) {
            FeatureUsageData groupData = FUStateUsagesLogger.addProject(project, context);
            for (UsageDescriptor usage : usages) {
                FeatureUsageData data = FUStateUsagesLogger.mergeWithEventData(groupData, usage.getData(), usage.getValue());
                Map<Object, Object> eventData = data != null ? data.build() : Collections.emptyMap();
                logger.logState(group, usage.getKey(), eventData);
            }
        }
        logger.logState(group, INVOKED, new FeatureUsageData().addProject(project).build());
    }

    @Nullable
    private static FeatureUsageData addProject(@Nullable Project project, @Nullable FeatureUsageData context) {
        if (project == null && context == null) {
            return null;
        }
        return context != null ? context.addProject(project) : new FeatureUsageData().addProject(project);
    }

    @Nullable
    public static FeatureUsageData mergeWithEventData(@Nullable FeatureUsageData groupData, @Nullable FeatureUsageData data, int value) {
        FeatureUsageData newData;
        if (data == null && value == 1) {
            return groupData;
        }
        FeatureUsageData featureUsageData = newData = groupData == null ? new FeatureUsageData() : groupData.copy();
        if (value != 1) {
            newData.addData("value", value);
        }
        if (data != null) {
            newData.merge(data, "event_");
        }
        return newData;
    }

    public static void logStateEvent(@NotNull FeatureUsageGroup group, @NotNull String event, @NotNull FeatureUsageData data) {
        FeatureUsageLogger.INSTANCE.logState(group, event, data.build());
        FeatureUsageLogger.INSTANCE.logState(group, INVOKED);
    }
}

