/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.tools;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToolsUsagesCollector
extends ProjectUsagesCollector {
    private static final Predicate<ScopeToolState> BUNDLED = state -> {
        IdeaPluginDescriptor descriptor = AbstractToolsUsagesCollector.getIdeaPluginDescriptor(state);
        return descriptor != null && descriptor.isBundled() && PluginManagerMain.isDevelopedByJetBrains(descriptor);
    };
    private static final Predicate<ScopeToolState> LISTED = state -> {
        IdeaPluginDescriptor descriptor = AbstractToolsUsagesCollector.getIdeaPluginDescriptor(state);
        return descriptor != null && !descriptor.isBundled() && StatisticsUtilKt.isSafeToReportFrom(descriptor);
    };
    private static final Predicate<ScopeToolState> ENABLED = state -> !state.getTool().isEnabledByDefault() && state.isEnabled();
    private static final Predicate<ScopeToolState> DISABLED = state -> state.getTool().isEnabledByDefault() && !state.isEnabled();

    private static IdeaPluginDescriptor getIdeaPluginDescriptor(ScopeToolState state) {
        InspectionEP extension = state.getTool().getExtension();
        return extension != null ? (IdeaPluginDescriptor)ObjectUtils.tryCast((Object)extension.getPluginDescriptor(), IdeaPluginDescriptor.class) : null;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        List<ScopeToolState> tools = InspectionProjectProfileManager.getInstance(project).getCurrentProfile().getAllTools();
        return this.filter(tools.stream()).map(ScopeToolState::getTool).map(tool -> new UsageDescriptor(tool.getID(), this.getInspectionToolData((InspectionToolWrapper)tool))).collect(Collectors.toSet());
    }

    @NotNull
    protected FeatureUsageData getInspectionToolData(InspectionToolWrapper tool) {
        FeatureUsageData data = new FeatureUsageData();
        String language = tool.getLanguage();
        if (StringUtil.isNotEmpty((String)language)) {
            data.addData("lang", language);
        }
        return data;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @NotNull
    protected abstract Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> var1);

    public static class DisabledListedToolsUsagesCollector
    extends AbstractListedToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            return "disabled.listed.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            return tools.filter(DISABLED).filter(LISTED);
        }
    }

    public static class DisabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            return "disabled.bundled.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            return tools.filter(DISABLED).filter(BUNDLED);
        }
    }

    public static class EnabledListedToolsUsagesCollector
    extends AbstractListedToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            return "enabled.listed.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            return tools.filter(ENABLED).filter(LISTED);
        }
    }

    public static class EnabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            return "enabled.bundled.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            return tools.filter(ENABLED).filter(BUNDLED);
        }
    }

    protected static abstract class AbstractListedToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        protected AbstractListedToolsUsagesCollector() {
        }

        @Override
        @NotNull
        protected FeatureUsageData getInspectionToolData(InspectionToolWrapper tool) {
            FeatureUsageData data = super.getInspectionToolData(tool);
            PluginId pluginId = tool.getExtension().getPluginId();
            if (pluginId != null) {
                data.addData("plugin_id", pluginId.getIdString());
            }
            return data;
        }
    }
}

