/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.application.Topics;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.FrameStateListener;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence;
import com.intellij.internal.statistic.service.fus.collectors.LegacyApplicationUsageTriggers;
import com.intellij.internal.statistic.service.fus.collectors.LegacyFUSProjectUsageTrigger;
import com.intellij.internal.statistic.updater.StatisticsNotificationManager;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StatisticsJobsScheduler
implements BaseComponent {
    private static final int SEND_STATISTICS_INITIAL_DELAY_IN_MILLIS = 1200000;
    private static final int SEND_EVENT_LOG_DELAY_IN_MILLIS = 3600000;
    private static final int SEND_STATISTICS_DELAY_IN_MIN = 5;
    public static final int LOG_APPLICATION_STATES_INITIAL_DELAY_IN_MIN = 15;
    public static final int LOG_APPLICATION_STATES_DELAY_IN_MIN = 1440;
    public static final int LOG_PROJECTS_STATES_INITIAL_DELAY_IN_MIN = 30;
    public static final int LOG_PROJECTS_STATES_DELAY_IN_MIN = 720;
    private static final Map<Project, Future> myPersistStatisticsSessionsMap = Collections.synchronizedMap(new HashMap());

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (StatisticsUploadAssistant.isShouldShowNotification()) {
            final Disposable disposable = Disposer.newDisposable();
            Topics.subscribe((Topic)FrameStateListener.TOPIC, (Disposable)disposable, (Object)new FrameStateListener(){

                public void onFrameActivated() {
                    if (StatisticsJobsScheduler.isEmpty(((WindowManagerEx)WindowManager.getInstance()).getMostRecentFocusedWindow())) {
                        StatisticsService statisticsService = StatisticsUploadAssistant.getEventLogStatisticsService();
                        ApplicationManager.getApplication().invokeLater(() -> StatisticsNotificationManager.showNotification(statisticsService));
                        Disposer.dispose((Disposable)disposable);
                    }
                }
            });
        }
        StatisticsJobsScheduler.runEventLogStatisticsService();
        StatisticsJobsScheduler.runStatesLogging();
        StatisticsJobsScheduler.runLegacyDataCleanupService();
    }

    private static void runEventLogStatisticsService() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            if (FeatureUsageLogger.INSTANCE.isEnabled()) {
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(StatisticsUploadAssistant.getEventLogStatisticsService(), 5);
            }
        }, 1200000L, 3600000L, TimeUnit.MILLISECONDS);
    }

    private static void runStatesLogging() {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logApplicationStates(), 15L, 1440L, TimeUnit.MINUTES);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                ScheduledFuture<?> future2 = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logProjectStates(project), 30L, 720L, TimeUnit.MINUTES);
                myPersistStatisticsSessionsMap.put(project, future2);
                LegacyFUSProjectUsageTrigger.cleanup(project);
            }

            public void projectClosed(@NotNull Project project) {
                Future future2 = (Future)myPersistStatisticsSessionsMap.remove(project);
                if (future2 != null) {
                    future2.cancel(true);
                }
            }
        });
    }

    private static void runLegacyDataCleanupService() {
        JobScheduler.getScheduler().schedule(() -> {
            FUStatisticsPersistence.clearLegacyStates();
            LegacyApplicationUsageTriggers.cleanup();
        }, 1L, TimeUnit.MINUTES);
    }

    private static void runStatisticsServiceWithDelay(@NotNull StatisticsService statisticsService, int delayInMin) {
        JobScheduler.getScheduler().schedule(statisticsService::send, (long)delayInMin, TimeUnit.MINUTES);
    }

    public StatisticsJobsScheduler() {
        NotificationsConfigurationImpl.remove("SendUsagesStatistics");
    }

    private static boolean isEmpty(Window window) {
        BalloonLayout layout;
        if (window instanceof IdeFrameImpl && (layout = ((IdeFrameImpl)window).getBalloonLayout()) instanceof BalloonLayoutImpl) {
            return ((BalloonLayoutImpl)layout).isEmpty();
        }
        return false;
    }
}

