/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageDataKt;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u001a$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004H\u0002\u001a_\u0010\u000e\u001a\u00020\t\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u0002H\u000f2\u0006\u0010\u0014\u001a\u0002H\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00050\u0016\u00a2\u0006\u0002\u0010\u0018\u001aM\u0010\u000e\u001a\u00020\t\"\u0004\b\u0000\u0010\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u0002H\u000f2\u0006\u0010\u0014\u001a\u0002H\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001b\u001a\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002\u001a&\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$\u001a\u0016\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(\u001a\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002\u001a\u0016\u0010*\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0001\u001a$\u0010*\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00012\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d\u001a\u001c\u0010,\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010-\u001a\u0012\u0010.\u001a\u00020/2\n\u00100\u001a\u0006\u0012\u0002\b\u000301\u001a\u000e\u00102\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"\u001a\u0010\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0001H\u0002\u001a\u0010\u00105\u001a\u00020(2\b\u00106\u001a\u0004\u0018\u000107\u001a\u0010\u00108\u001a\u00020(2\b\u00106\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u00109\u001a\u00020(2\b\u0010:\u001a\u0004\u0018\u00010\u001e\u001a(\u0010;\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\r0\u0004\u001a\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006?"}, d2={"kilo", "", "mega", "safeToReportPluginIds", "", "", "getSafeToReportPluginIds", "()Ljava/util/Set;", "addAll", "", "result", "Lcom/intellij/util/containers/ObjectIntHashMap;", "usages", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "addIfDiffers", "T", "V", "set", "", "settingsBean", "defaultSettingsBean", "valueFunction", "Lkotlin/Function1;", "featureIdFunction", "(Ljava/util/Set;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "", "featureIdPrefix", "(Ljava/util/Set;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "collectSafePluginDescriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "createData", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/internal/statistic/service/fus/collectors/FUSUsageContext;", "getBooleanUsage", "key", "value", "", "getBundledJetBrainsPluginDescriptors", "getCountingUsage", "steps", "getEnumUsage", "", "getPluginType", "Lcom/intellij/internal/statistic/utils/PluginType;", "clazz", "Ljava/lang/Class;", "getProjectId", "humanize", "number", "isDevelopedByJetBrains", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "isSafeToReport", "isSafeToReportFrom", "descriptor", "merge", "first", "second", "toUsageDescriptors", "intellij.platform.ide.impl"})
public final class StatisticsUtilKt {
    private static final int kilo = 1000;
    private static final int mega = 1000000;

    @NotNull
    public static final String getProjectId(@NotNull Project project) {
        return EventLogConfiguration.INSTANCE.anonymize(ProjectUtil.getProjectCacheFileName$default((Project)project, (boolean)false, null, null, (int)7, null));
    }

    @NotNull
    public static final Map<String, Object> createData(@Nullable Project project, @Nullable FUSUsageContext context) {
        return FeatureUsageDataKt.newData(project, context);
    }

    public static final boolean isDevelopedByJetBrains(@Nullable PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        return plugin == null || PluginManagerMain.isDevelopedByJetBrains(plugin.getVendor());
    }

    @NotNull
    public static final UsageDescriptor getBooleanUsage(@NotNull String key, boolean value) {
        return new UsageDescriptor(key + (value ? ".enabled" : ".disabled"), 1);
    }

    @NotNull
    public static final UsageDescriptor getEnumUsage(@NotNull String key, @Nullable Enum<?> value) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(key).append(".");
        Enum<?> enum_ = value;
        if (enum_ != null && (enum_ = enum_.name()) != null) {
            Enum<?> enum_2 = enum_;
            Locale locale = Locale.ENGLISH;
            StringBuilder stringBuilder2 = stringBuilder;
            Enum<?> enum_3 = enum_2;
            if (enum_3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)((Object)enum_3)).toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
            String string3 = string2;
            stringBuilder = stringBuilder2;
            string = string3;
        } else {
            string = null;
        }
        int n = 1;
        String string4 = stringBuilder.append(string).toString();
        return new UsageDescriptor(string4, n);
    }

    @NotNull
    public static final UsageDescriptor getCountingUsage(@NotNull String key, int value, @NotNull List<Integer> steps) {
        int stepIndex;
        if (steps.isEmpty()) {
            return new UsageDescriptor(key + '.' + value, 1);
        }
        if (value < ((Number)steps.get(0)).intValue()) {
            return new UsageDescriptor(key + ".<" + ((Number)steps.get(0)).intValue(), 1);
        }
        for (stepIndex = 0; stepIndex < steps.size() - 1 && value >= ((Number)steps.get(stepIndex + 1)).intValue(); ++stepIndex) {
        }
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        String stepName = StatisticsUtilKt.humanize(step) + (addPlus ? "+" : "");
        return new UsageDescriptor(key + '.' + stepName, 1);
    }

    @NotNull
    public static final UsageDescriptor getCountingUsage(@NotNull String key, int value) {
        Object element$iv;
        block5: {
            List fixedSteps;
            if (value > 0xCCCCCCC) {
                return new UsageDescriptor(key + ".MANY", 1);
            }
            if (value < 0) {
                return new UsageDescriptor(key + ".<0", 1);
            }
            if (value < 3) {
                return new UsageDescriptor(key + '.' + value, 1);
            }
            List $receiver$iv = fixedSteps = CollectionsKt.listOf((Object[])new Integer[]{3, 5, 10, 15, 30, 50});
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(it <= value)) continue;
                break block5;
            }
            throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
        }
        int step = ((Number)element$iv).intValue();
        while (value >= step * 2 && value >= (step *= 2) * 5) {
            step *= 5;
        }
        String stepName = StatisticsUtilKt.humanize(step);
        return new UsageDescriptor(key + '.' + stepName + '+', 1);
    }

    private static final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / mega;
        int k = number % mega / 1000;
        int r = number % 1000;
        String ms = m > 0 ? "" + m + 'M' : "";
        String ks = k > 0 ? "" + k + 'K' : "";
        String rs = r > 0 ? String.valueOf(r) : "";
        return ms + ks + rs;
    }

    public static final <T> void addIfDiffers(@NotNull Set<? super UsageDescriptor> set2, T settingsBean, T defaultSettingsBean, @NotNull Function1<? super T, ? extends Object> valueFunction, @NotNull String featureIdPrefix) {
        StatisticsUtilKt.addIfDiffers(set2, settingsBean, defaultSettingsBean, valueFunction, (Function1)new Function1<Object, String>(featureIdPrefix){
            final /* synthetic */ String $featureIdPrefix;

            @NotNull
            public final String invoke(@NotNull Object it) {
                return this.$featureIdPrefix + '.' + it;
            }
            {
                this.$featureIdPrefix = string;
                super(1);
            }
        });
    }

    public static final <T, V> void addIfDiffers(@NotNull Set<? super UsageDescriptor> set2, T settingsBean, T defaultSettingsBean, @NotNull Function1<? super T, ? extends V> valueFunction, @NotNull Function1<? super V, String> featureIdFunction) {
        Object defaultValue;
        Object value = valueFunction.invoke(settingsBean);
        if (!Comparing.equal((Object)value, (Object)(defaultValue = valueFunction.invoke(defaultSettingsBean)))) {
            set2.add(new UsageDescriptor((String)featureIdFunction.invoke(value), 1));
        }
    }

    @NotNull
    public static final Set<UsageDescriptor> toUsageDescriptors(@NotNull ObjectIntHashMap<String> result2) {
        if (result2.isEmpty()) {
            return SetsKt.emptySet();
        }
        THashSet descriptors = new THashSet(result2.size());
        result2.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(descriptors){
            final /* synthetic */ THashSet $descriptors;

            public final boolean execute(String key, int value) {
                this.$descriptors.add((Object)new UsageDescriptor(key, value));
                return true;
            }
            {
                this.$descriptors = tHashSet;
            }
        });
        return (Set)descriptors;
    }

    @NotNull
    public static final Set<UsageDescriptor> merge(@NotNull Set<UsageDescriptor> first, @NotNull Set<UsageDescriptor> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ObjectIntHashMap merged = new ObjectIntHashMap();
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, first);
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, second);
        return StatisticsUtilKt.toUsageDescriptors((ObjectIntHashMap<String>)merged);
    }

    private static final void addAll(ObjectIntHashMap<String> result2, Set<UsageDescriptor> usages) {
        for (UsageDescriptor usage : usages) {
            String key = usage.getKey();
            result2.put((Object)key, result2.get((Object)key, 0) + usage.getValue());
        }
    }

    private static final Set<String> getSafeToReportPluginIds() {
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        if (project.isDisposed()) {
            return SetsKt.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)safeToReportPluginIds.1.INSTANCE);
    }

    private static final List<IdeaPluginDescriptor> collectSafePluginDescriptors() {
        if (ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
            try {
                List<IdeaPluginDescriptor> cached = RepositoryHelper.loadCachedPlugins();
                if (cached != null) {
                    ArrayList plugins2 = new ArrayList();
                    plugins2.addAll(cached);
                    plugins2.addAll(StatisticsUtilKt.getBundledJetBrainsPluginDescriptors());
                    return plugins2;
                }
                ApplicationManager.getApplication().executeOnPooledThread((Runnable)collectSafePluginDescriptors.1.INSTANCE);
                return CollectionsKt.emptyList();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return StatisticsUtilKt.getBundledJetBrainsPluginDescriptors();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IdeaPluginDescriptor> getBundledJetBrainsPluginDescriptors() {
        void var2_2;
        void $receiver$iv$iv;
        IdeaPluginDescriptor[] $receiver$iv;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = $receiver$iv = PluginManager.getPlugins();
        Collection destination$iv$iv = new ArrayList();
        void var3_3 = $receiver$iv$iv;
        int n = ((void)var3_3).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var3_3[i];
            boolean bl = false;
            if (!(it.isBundled() && PluginManagerMain.isDevelopedByJetBrains((IdeaPluginDescriptor)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)var2_2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSafeToReportFrom(@Nullable IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (StatisticsUtilKt.isDevelopedByJetBrains(descriptor.getPluginId())) {
            return true;
        }
        if (descriptor.isBundled()) return false;
        PluginId pluginId = descriptor.getPluginId();
        if (!StatisticsUtilKt.isSafeToReport(pluginId != null ? pluginId.getIdString() : null)) return false;
        return true;
    }

    public static final boolean isSafeToReport(@Nullable String pluginId) {
        return pluginId != null && StatisticsUtilKt.getSafeToReportPluginIds().contains(pluginId);
    }

    @NotNull
    public static final PluginType getPluginType(@NotNull Class<?> clazz) {
        PluginId pluginId = PluginManagerCore.getPluginByClassName(clazz.getName());
        if (pluginId == null) {
            return PluginType.PLATFORM;
        }
        PluginId pluginId2 = pluginId;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin(pluginId2);
        if (ideaPluginDescriptor == null) {
            return PluginType.UNKNOWN;
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        if (PluginManagerMain.isDevelopedByJetBrains(plugin)) {
            return plugin.isBundled() ? PluginType.JB_BUNDLED : PluginType.JB_NOT_BUNDLED;
        }
        boolean listed = !plugin.isBundled() && StatisticsUtilKt.isSafeToReport(pluginId2.getIdString());
        return listed ? PluginType.LISTED : PluginType.NOT_LISTED;
    }

    static {
        mega = 1000000;
    }

    public static final /* synthetic */ List access$collectSafePluginDescriptors() {
        return StatisticsUtilKt.collectSafePluginDescriptors();
    }
}

