/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.validation;

import com.intellij.internal.validation.ValidTest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ValidationTest
extends DialogWrapper {
    private final ValidTest myPanel = new ValidTest();
    final ValidationInfo[] ERRORS;

    protected ValidationTest(Project project) {
        super(project);
        this.ERRORS = new ValidationInfo[]{new ValidationInfo("Field1 should not be empty", (JComponent)this.myPanel.field1), new ValidationInfo("Field2 is zip. It should contain 5 digits", (JComponent)this.myPanel.field2), new ValidationInfo("Field3. Value is not chosen", (JComponent)this.myPanel.field3), new ValidationInfo("Field4: Select A or B", (JComponent)this.myPanel.p4), new ValidationInfo("Field5: You should accept license agreement<br/>text text text text text text text text text text text text<br/>text text text text text text text text text text text text"), new ValidationInfo("editableComboBox: should contain some value", (JComponent)this.myPanel.comboBox), new ValidationInfo("Spinner should contain values between 20 and 30", (JComponent)this.myPanel.spinner)};
        this.init();
        this.myPanel.field5.addActionListener(e -> this.myPanel.spinner.setEnabled(this.myPanel.field5.isSelected()));
        this.myPanel.spinner.setEnabled(this.myPanel.field5.isSelected());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.field2;
    }

    protected void doOKAction() {
        super.doOKAction();
        Messages.showInfoMessage((String)"on OK", (String)"Info");
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ArrayList<ValidationInfo> result2 = new ArrayList<ValidationInfo>();
        if (this.myPanel.field1.getText().isEmpty()) {
            result2.add(this.ERRORS[0]);
        }
        if (!Pattern.compile("[0-9]{5}").matcher(this.myPanel.field2.getText()).matches()) {
            result2.add(this.ERRORS[1]);
        }
        if (this.myPanel.field3.getSelectedItem() == null || "".equals(this.myPanel.field3.getSelectedItem())) {
            result2.add(this.ERRORS[2]);
        }
        if (!this.myPanel.field4A.isSelected() && !this.myPanel.field4B.isSelected()) {
            result2.add(this.ERRORS[3]);
        }
        if (!this.myPanel.field5.isSelected()) {
            result2.add(this.ERRORS[4]);
        }
        if (this.myPanel.comboBox.getSelectedItem() == null || "".equals(this.myPanel.comboBox.getSelectedItem()) || this.myPanel.comboBox.getEditor().getItem() == null) {
            result2.add(this.ERRORS[5]);
        }
        Object value = this.myPanel.spinner.getValue();
        try {
            int iv = Integer.parseInt(String.valueOf(value));
            if (value == null || iv < 20 || iv > 30) {
                result2.add(this.ERRORS[6]);
            }
        }
        catch (NumberFormatException nfe) {
            result2.add(this.ERRORS[6]);
        }
        return result2;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.panel;
    }
}

