/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ExternalResourceManagerExImpl;
import com.intellij.javaee.ResourceRegistrar;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceRegistrarImpl
implements ResourceRegistrar {
    private final Map<String, Map<String, ExternalResourceManagerExImpl.Resource>> myResources = new THashMap();
    private final List<String> myIgnored = new ArrayList<String>();

    public void addStdResource(@NonNls String resource, @NonNls String fileName2) {
        this.addStdResource(resource, null, fileName2, this.getClass());
    }

    public void addStdResource(@NonNls String resource, @NonNls String fileName2, Class klass) {
        this.addStdResource(resource, null, fileName2, klass);
    }

    public void addStdResource(@NonNls String resource, @NonNls String version2, @NonNls String fileName2, @Nullable Class klass, @Nullable ClassLoader classLoader) {
        Map map2 = ExternalResourceManagerExImpl.getMap(this.myResources, version2, true);
        assert (map2 != null);
        map2.put(resource, new ExternalResourceManagerExImpl.Resource(fileName2, klass, classLoader));
    }

    public void addStdResource(@NonNls String resource, @Nullable @NonNls String version2, @NonNls String fileName2, Class klass) {
        this.addStdResource(resource, version2, fileName2, klass, null);
    }

    public void addIgnoredResource(@NonNls String url) {
        this.myIgnored.add(url);
    }

    public void addInternalResource(@NonNls String resource, @NonNls String fileName2) {
        this.addInternalResource(resource, null, fileName2, this.getClass());
    }

    public void addInternalResource(@NonNls String resource, @NonNls String fileName2, Class clazz) {
        this.addInternalResource(resource, null, fileName2, clazz);
    }

    public void addInternalResource(@NonNls String resource, @NonNls String version2, @NonNls String fileName2) {
        this.addInternalResource(resource, version2, fileName2, this.getClass());
    }

    public void addInternalResource(@NonNls String resource, @Nullable @NonNls String version2, @NonNls String fileName2, @Nullable Class clazz) {
        this.addStdResource(resource, version2, "/standardSchemas/" + fileName2, clazz);
    }

    @NotNull
    public Map<String, Map<String, ExternalResourceManagerExImpl.Resource>> getResources() {
        return this.myResources;
    }

    @NotNull
    public List<String> getIgnored() {
        return this.myIgnored;
    }
}

