/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jdkEx;

import com.intellij.jdkEx.DefDisplayModeEx;
import com.intellij.jdkEx.DefInputEventEx;
import com.intellij.jdkEx.DisplayModeEx;
import com.intellij.jdkEx.InputEventEx;
import com.intellij.jdkEx.JBDisplayModeEx;
import com.intellij.jdkEx.JBInputEventEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.MethodInvocator;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAccessor;

@ApiStatus.Experimental
public class JdkEx {
    @NotNull
    public static InputEventEx getInputEventEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBInputEventEx();
        }
        return new DefInputEventEx();
    }

    public static DisplayModeEx getDisplayModeEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBDisplayModeEx();
        }
        return new DefDisplayModeEx();
    }

    public static boolean isCustomDecorationSupported() {
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWin10OrNewer) {
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("java.awt.Window"), "setHasCustomDecoration", new Class[0]);
                return invocator.isAvailable();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setHasCustomDecoration(@NotNull Window window) {
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWindows) {
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("java.awt.Window"), "setHasCustomDecoration", new Class[0]);
                if (invocator.isAvailable()) {
                    invocator.invoke((Object)window, new Object[0]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void setCustomDecorationHitTestSpots(@NotNull Window window, @NotNull List<Rectangle> spots) {
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWindows) {
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("sun.awt.windows.WWindowPeer"), "setCustomDecorationHitTestSpots", new Class[]{List.class});
                if (invocator.isAvailable()) {
                    invocator.invoke(AWTAccessor.getComponentAccessor().getPeer(window), new Object[]{spots});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

