/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonDialectUtil {
    public static boolean isStandardJson(@NotNull PsiElement element) {
        return JsonDialectUtil.isStandardJson(JsonDialectUtil.getLanguage(element));
    }

    public static Language getLanguage(@NotNull PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return JsonLanguage.INSTANCE;
        }
        Language language = file2.getLanguage();
        return language instanceof JsonLanguage ? language : JsonLanguage.INSTANCE;
    }

    public static boolean isStandardJson(@Nullable Language language) {
        return language == JsonLanguage.INSTANCE;
    }
}

