/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> cls) {
        if (expression == null) {
            return null;
        }
        if (cls.isAssignableFrom(expression.getClass())) {
            return (T)expression;
        }
        return null;
    }

    @Nullable
    public static <T extends JsonElement> T getPropertyValueOfType(@NotNull JsonObject object, @NotNull String name, @NotNull Class<T> clazz) {
        JsonProperty property = object.findProperty(name);
        if (property == null) {
            return null;
        }
        return (T)((JsonElement)ObjectUtils.tryCast((Object)property.getValue(), clazz));
    }

    @Nullable
    public static List<String> getChildAsStringList(@NotNull JsonObject object, @NotNull String name) {
        JsonArray array = JsonUtil.getPropertyValueOfType(object, name, JsonArray.class);
        if (array != null) {
            return array.getValueList().stream().filter(value -> value instanceof JsonStringLiteral).map(value -> StringUtil.unquoteString((String)value.getText())).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsSingleStringOrList(@NotNull JsonObject object, @NotNull String name) {
        List<String> list2 = JsonUtil.getChildAsStringList(object, name);
        if (list2 != null) {
            return list2;
        }
        JsonStringLiteral literal = JsonUtil.getPropertyValueOfType(object, name, JsonStringLiteral.class);
        return literal == null ? null : Collections.singletonList(StringUtil.unquoteString((String)literal.getText()));
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        return element instanceof JsonValue && element.getParent() instanceof JsonArray;
    }

    public static int getArrayIndexOfItem(@NotNull PsiElement e) {
        PsiElement parent = e.getParent();
        if (!(parent instanceof JsonArray)) {
            return -1;
        }
        List<JsonValue> elements = ((JsonArray)parent).getValueList();
        for (int i = 0; i < elements.size(); ++i) {
            if (e != elements.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isJsonFile(@NotNull VirtualFile file2) {
        FileType type = file2.getFileType();
        return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof JsonLanguage;
    }
}

