/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JsonStringPropertyInsertHandler
implements InsertHandler<LookupElement> {
    private final String myNewValue;

    public JsonStringPropertyInsertHandler(@NotNull String newValue) {
        this.myNewValue = newValue;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        TextRange toDelete;
        PsiElement element = context.getFile().findElementAt(context.getStartOffset());
        JsonStringLiteral literal = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, JsonStringLiteral.class, (boolean)false);
        if (literal == null) {
            return;
        }
        JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class);
        if (property == null) {
            return;
        }
        String textToInsert = "";
        TextRange literalRange = literal.getTextRange();
        if (literal.getValue().equals(this.myNewValue)) {
            toDelete = new TextRange(literalRange.getEndOffset(), literalRange.getEndOffset());
        } else {
            toDelete = literalRange;
            textToInsert = StringUtil.wrapWithDoubleQuote((String)this.myNewValue);
        }
        int newCaretOffset = literalRange.getStartOffset() + 1 + this.myNewValue.length();
        boolean showAutoPopup = false;
        if (property.getNameElement().equals(literal) && property.getValue() == null) {
            textToInsert = textToInsert + ":\"\"";
            newCaretOffset += 3;
            if (JsonStringPropertyInsertHandler.needCommaAfter(property)) {
                textToInsert = textToInsert + ",";
            }
            showAutoPopup = true;
        }
        context.getDocument().replaceString(toDelete.getStartOffset(), toDelete.getEndOffset(), (CharSequence)textToInsert);
        context.getEditor().getCaretModel().moveToOffset(newCaretOffset);
        JsonStringPropertyInsertHandler.reformat(context, toDelete.getStartOffset(), toDelete.getStartOffset() + textToInsert.length());
        if (showAutoPopup) {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    }

    private static boolean needCommaAfter(@NotNull JsonProperty property) {
        for (PsiElement element = property.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (element instanceof JsonProperty) {
                return true;
            }
            if (element.getNode().getElementType() != JsonElementTypes.COMMA) continue;
            return false;
        }
        return false;
    }

    private static void reformat(@NotNull InsertionContext context, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context.getProject());
        codeStyleManager.reformatText(context.getFile(), startOffset, endOffset);
    }
}

