/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonFileType;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonCopyPastePostProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    static final List<TextBlockTransferableData> DATA_LIST = Collections.singletonList(new DumbData());

    @Override
    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(PsiFile file2, Editor editor, int[] startOffsets, int[] endOffsets) {
        return ContainerUtil.emptyList();
    }

    @Override
    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(Transferable content) {
        return DATA_LIST;
    }

    @Override
    public void processTransferableData(Project project, Editor editor, RangeMarker bounds2, int caretOffset, Ref<Boolean> indented, List<TextBlockTransferableData> values) {
        JsonCopyPastePostProcessor.fixCommasOnPaste(project, editor, bounds2);
    }

    private static void fixCommasOnPaste(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds2) {
        if (!JsonEditorOptions.getInstance().COMMA_ON_PASTE) {
            return;
        }
        if (!JsonCopyPastePostProcessor.isJsonEditor(project, editor)) {
            return;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        manager.commitDocument(editor.getDocument());
        PsiFile psiFile = manager.getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        JsonCopyPastePostProcessor.fixTrailingComma(bounds2, psiFile, manager);
        JsonCopyPastePostProcessor.fixLeadingComma(bounds2, psiFile, manager);
    }

    private static boolean isJsonEditor(@NotNull Project project, @NotNull Editor editor) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file2 == null) {
            return false;
        }
        FileType fileType = file2.getFileType();
        if (fileType instanceof JsonFileType) {
            return true;
        }
        if (!(fileType instanceof ScratchFileType)) {
            return false;
        }
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) instanceof JsonFile;
    }

    private static void fixLeadingComma(@NotNull RangeMarker bounds2, @NotNull PsiFile psiFile, @NotNull PsiDocumentManager manager) {
        PsiElement propertyOrArrayItem;
        PsiElement startElement = JsonCopyPastePostProcessor.skipWhitespaces(psiFile.findElementAt(bounds2.getStartOffset()));
        PsiElement psiElement = propertyOrArrayItem = startElement instanceof JsonProperty ? startElement : JsonCopyPastePostProcessor.getParentPropertyOrArrayItem(startElement);
        if (propertyOrArrayItem == null) {
            return;
        }
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)propertyOrArrayItem);
        if (prevSibling instanceof PsiErrorElement) {
            int offset = prevSibling.getTextRange().getEndOffset();
            ApplicationManager.getApplication().runWriteAction(() -> bounds2.getDocument().insertString(offset, (CharSequence)","));
            manager.commitDocument(bounds2.getDocument());
        }
    }

    @Nullable
    private static PsiElement getParentPropertyOrArrayItem(@Nullable PsiElement startElement) {
        PsiElement propertyOrArrayItem = PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{JsonProperty.class, JsonArray.class});
        if (propertyOrArrayItem instanceof JsonArray) {
            for (JsonValue value : ((JsonArray)propertyOrArrayItem).getValueList()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)startElement, (boolean)false)) continue;
                return value;
            }
            return null;
        }
        return propertyOrArrayItem;
    }

    private static void fixTrailingComma(@NotNull RangeMarker bounds2, @NotNull PsiFile psiFile, @NotNull PsiDocumentManager manager) {
        PsiElement endElement = JsonCopyPastePostProcessor.skipWhitespaces(psiFile.findElementAt(bounds2.getEndOffset() - 1));
        if (endElement != null && endElement.getTextOffset() >= bounds2.getEndOffset()) {
            endElement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endElement);
        }
        if (endElement instanceof LeafPsiElement && ((LeafPsiElement)endElement).getElementType() == JsonElementTypes.COMMA) {
            PsiElement nextNext = JsonCopyPastePostProcessor.skipWhitespaces(endElement.getNextSibling());
            if (nextNext instanceof LeafPsiElement && (((LeafPsiElement)nextNext).getElementType() == JsonElementTypes.R_CURLY || ((LeafPsiElement)nextNext).getElementType() == JsonElementTypes.R_BRACKET)) {
                PsiElement finalEndElement = endElement;
                ApplicationManager.getApplication().runWriteAction(() -> finalEndElement.delete());
            }
        } else {
            PsiElement property = JsonCopyPastePostProcessor.getParentPropertyOrArrayItem(endElement);
            if (endElement instanceof PsiErrorElement || property != null && JsonCopyPastePostProcessor.skipWhitespaces(property.getNextSibling()) instanceof PsiErrorElement) {
                PsiElement finalEndElement1 = endElement;
                ApplicationManager.getApplication().runWriteAction(() -> bounds2.getDocument().insertString(JsonCopyPastePostProcessor.getOffset(property, finalEndElement1), (CharSequence)","));
                manager.commitDocument(bounds2.getDocument());
            }
        }
    }

    private static int getOffset(@Nullable PsiElement property, @Nullable PsiElement finalEndElement1) {
        if (finalEndElement1 instanceof PsiErrorElement) {
            return finalEndElement1.getTextOffset();
        }
        assert (finalEndElement1 != null);
        return property != null ? property.getTextRange().getEndOffset() : finalEndElement1.getTextOffset();
    }

    @Nullable
    private static PsiElement skipWhitespaces(@Nullable PsiElement element) {
        while (element instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        return element;
    }

    static class DumbData
    implements TextBlockTransferableData {
        private static final DataFlavor DATA_FLAVOR = new DataFlavor(JsonCopyPastePostProcessor.class, "class: JsonCopyPastePostProcessor");

        DumbData() {
        }

        @Override
        public DataFlavor getFlavor() {
            return DATA_FLAVOR;
        }

        @Override
        public int getOffsetCount() {
            return 0;
        }

        @Override
        public int getOffsets(int[] offsets, int index) {
            return index;
        }

        @Override
        public int setOffsets(int[] offsets, int index) {
            return index;
        }
    }
}

