/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JsonTypedHandler
extends TypedHandlerDelegate {
    private boolean myWhitespaceAdded;

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (file2 instanceof JsonFile) {
            JsonTypedHandler.processPairedBracesComma(c, editor, file2);
            this.addWhiteSpaceAfterColonIfNeeded(c, editor, file2);
            this.removeRedundantWhitespaceIfAfterColon(c, editor, file2);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private void removeRedundantWhitespaceIfAfterColon(char c, Editor editor, PsiFile file2) {
        if (!this.myWhitespaceAdded || c != ' ' || !JsonEditorOptions.getInstance().AUTO_WHITESPACE_AFTER_COLON) {
            if (c != ':') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        PsiElement element = file2.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            editor.getDocument().deleteString(offset - 1, offset);
        }
        this.myWhitespaceAdded = false;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (file2 instanceof JsonFile) {
            JsonTypedHandler.addPropertyNameQuotesIfNeeded(c, editor, file2);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private void addWhiteSpaceAfterColonIfNeeded(char c, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (c != ':' || !JsonEditorOptions.getInstance().AUTO_WHITESPACE_AFTER_COLON) {
            if (c != ' ') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.skipWhitespacesBackward((PsiElement)file2.findElementAt(offset)), JsonProperty.class, (boolean)false);
        if (element == null) {
            this.myWhitespaceAdded = false;
            return;
        }
        ASTNode[] children2 = element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.COLON}));
        if (children2.length == 0) {
            this.myWhitespaceAdded = false;
            return;
        }
        ASTNode colon = children2[0];
        ASTNode next = colon.getTreeNext();
        String text = next.getText();
        if (text.length() == 0 || !StringUtil.isEmptyOrSpaces((String)text) || StringUtil.isLineBreak((char)text.charAt(0))) {
            int insOffset = colon.getStartOffset() + 1;
            editor.getDocument().insertString(insOffset, (CharSequence)" ");
            editor.getCaretModel().moveToOffset(insOffset + 1);
            this.myWhitespaceAdded = true;
        } else {
            this.myWhitespaceAdded = false;
        }
    }

    private static void addPropertyNameQuotesIfNeeded(char c, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (c != ':' || !JsonDialectUtil.isStandardJson((PsiElement)file2) || !JsonEditorOptions.getInstance().AUTO_QUOTE_PROP_NAME) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)file2.findElementAt(offset));
        if (!(element instanceof JsonProperty)) {
            return;
        }
        JsonValue nameElement = ((JsonProperty)element).getNameElement();
        if (nameElement instanceof JsonReferenceExpression) {
            ((JsonProperty)element).setName(nameElement.getText());
            PsiDocumentManager.getInstance((Project)file2.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
    }

    public static void processPairedBracesComma(char c, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (!JsonEditorOptions.getInstance().COMMA_ON_MATCHING_BRACES) {
            return;
        }
        if (c != '[' && c != '{' && c != '\"' && c != '\'') {
            return;
        }
        SmartEnterProcessor.commitDocument((Editor)editor);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if ((c == '[' && parent instanceof JsonArray || c == '{' && parent instanceof JsonObject || (c == '\"' || c == '\'') && parent instanceof JsonStringLiteral) && JsonTypedHandler.shouldAddCommaInParentContainer((JsonValue)parent)) {
            editor.getDocument().insertString(parent.getTextRange().getEndOffset(), (CharSequence)",");
        }
    }

    private static boolean shouldAddCommaInParentContainer(@NotNull JsonValue item) {
        PsiElement nextElement;
        PsiElement parent = item.getParent();
        if ((parent instanceof JsonArray || parent instanceof JsonProperty) && (nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)(parent instanceof JsonProperty ? parent : item))) instanceof PsiErrorElement) {
            PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextElement);
            return parent instanceof JsonProperty ? forward instanceof JsonProperty : forward instanceof JsonValue;
        }
        return false;
    }
}

