/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonStringLiteralSelectionHandler
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (!(e.getParent() instanceof JsonStringLiteral)) {
            return false;
        }
        return !InjectedLanguageManager.getInstance((Project)e.getProject()).isInjectedFragment(e.getContainingFile());
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        IElementType type = e.getNode().getElementType();
        StringLiteralLexer lexer = new StringLiteralLexer(type == JsonElementTypes.SINGLE_QUOTED_STRING ? (char)'\'' : '\"', type, false, "/", false, false);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        SelectWordUtil.addWordHonoringEscapeSequences(editorText, e.getTextRange(), cursorOffset, (Lexer)lexer, result2);
        PsiElement parent = e.getParent();
        result2.add(ElementManipulators.getValueTextRange((PsiElement)parent).shiftRight(parent.getTextOffset()));
        return result2;
    }
}

