/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.smartEnter;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    public static final Logger LOG = Logger.getInstance(JsonSmartEnterProcessor.class);
    private boolean myShouldAddNewline = false;

    public JsonSmartEnterProcessor() {
        this.addFixers(new JsonObjectPropertyFixer(), new JsonArrayElementFixer());
        this.addEnterProcessors(new JsonEnterProcessor());
    }

    @Override
    protected void collectAdditionalElements(@NotNull PsiElement element, @NotNull List<PsiElement> result2) {
        for (PsiElement parent = element.getParent(); parent != null && !(parent instanceof JsonFile); parent = parent.getParent()) {
            result2.add(parent);
        }
    }

    private static boolean terminatedOnCurrentLine(@NotNull Editor editor, @NotNull PsiElement element) {
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getCurrentCaret().getOffset();
        int elementEndOffset = element.getTextRange().getEndOffset();
        if (document.getLineNumber(elementEndOffset) != document.getLineNumber(caretOffset)) {
            return false;
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)element, (boolean)true);
        return nextLeaf == null || nextLeaf instanceof PsiWhiteSpace && nextLeaf.getText().contains("\n");
    }

    private static boolean isFollowedByTerminal(@NotNull PsiElement element, IElementType type) {
        PsiElement nextLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        return nextLeaf != null && nextLeaf.getNode().getElementType() == type;
    }

    private class JsonEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        private JsonEnterProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doEnter(PsiElement atCaret, PsiFile file2, @NotNull Editor editor, boolean modified) {
            if (JsonSmartEnterProcessor.this.myShouldAddNewline) {
                try {
                    this.plainEnter(editor);
                }
                finally {
                    JsonSmartEnterProcessor.this.myShouldAddNewline = false;
                }
            }
            return true;
        }
    }

    private static class JsonObjectPropertyFixer
    extends SmartEnterProcessorWithFixers.Fixer<JsonSmartEnterProcessor> {
        private JsonObjectPropertyFixer() {
        }

        @Override
        public void apply(@NotNull Editor editor, @NotNull JsonSmartEnterProcessor processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            if (element instanceof JsonProperty) {
                JsonValue propertyValue = ((JsonProperty)element).getValue();
                if (propertyValue != null) {
                    if (JsonSmartEnterProcessor.terminatedOnCurrentLine(editor, propertyValue) && !JsonSmartEnterProcessor.isFollowedByTerminal(propertyValue, JsonElementTypes.COMMA)) {
                        editor.getDocument().insertString(propertyValue.getTextRange().getEndOffset(), (CharSequence)",");
                        processor2.myShouldAddNewline = true;
                    }
                } else {
                    JsonValue propertyKey = ((JsonProperty)element).getNameElement();
                    int keyEndOffset = propertyKey.getTextRange().getEndOffset();
                    if (JsonSmartEnterProcessor.terminatedOnCurrentLine(editor, propertyKey) && !JsonSmartEnterProcessor.isFollowedByTerminal(propertyKey, JsonElementTypes.COLON)) {
                        processor2.myFirstErrorOffset = keyEndOffset + 2;
                        editor.getDocument().insertString(keyEndOffset, (CharSequence)": ");
                    }
                }
            }
        }
    }

    private static class JsonArrayElementFixer
    extends SmartEnterProcessorWithFixers.Fixer<JsonSmartEnterProcessor> {
        private JsonArrayElementFixer() {
        }

        @Override
        public void apply(@NotNull Editor editor, @NotNull JsonSmartEnterProcessor processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            JsonValue arrayElement;
            if (element instanceof JsonValue && element.getParent() instanceof JsonArray && JsonSmartEnterProcessor.terminatedOnCurrentLine(editor, arrayElement = (JsonValue)element) && !JsonSmartEnterProcessor.isFollowedByTerminal(element, JsonElementTypes.COMMA)) {
                editor.getDocument().insertString(arrayElement.getTextRange().getEndOffset(), (CharSequence)",");
                processor2.myShouldAddNewline = true;
            }
        }
    }
}

